/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.supbusiness.bean.DeliveryrecordEntity;
import com.ejianc.business.supbusiness.bean.DeliveryrecorddetailEntity;
import com.ejianc.business.supbusiness.mapper.DeliveryrecordMapper;
import com.ejianc.business.supbusiness.service.IDeliveryrecordService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.utils.ProMaterialFileUtils;
import com.ejianc.business.supbusiness.vo.DeliveryrecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="deliveryrecordService")
public class DeliveryrecordServiceImpl
extends BaseServiceImpl<DeliveryrecordMapper, DeliveryrecordEntity>
implements IDeliveryrecordService {
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String deliveryrecordBillType = "EJCBT202408000012";
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String fileSourceType = "deliveryrecord";
    public static final String PUSH_DELIVERRRECORD_PLAN = "/ejc-zjkjmaterial-web/openapi/deliveryrecord/updateSignStatus";

    @Override
    public DeliveryrecordVO updateSignStatus(DeliveryrecordVO deliveryrecordVO) {
        DeliveryrecordEntity deliveryrecordEntity = (DeliveryrecordEntity)((Object)super.selectById((Serializable)deliveryrecordVO.getId()));
        if (deliveryrecordEntity.getSignStatus() == 2) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u786e\u8ba4,\u8bf7\u52ff\u91cd\u590d\u786e\u8ba4!");
        }
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u7b7e\u5b57\u5355\u4fe1\u606f>>>>>>>>>>>>>>>>>>>");
        deliveryrecordEntity.setSignStatus(2);
        deliveryrecordEntity.setSupOperateTime(new Date());
        deliveryrecordEntity.setSupOperatorName(deliveryrecordVO.getSupOperatorName());
        deliveryrecordEntity.setSupOperatorPhone(deliveryrecordVO.getSupOperatorPhone());
        deliveryrecordEntity.setSupOperatorUserCode(deliveryrecordVO.getSupOperatorUserCode());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("billId", CommonUtils.createString(deliveryrecordEntity.getSourceId()));
        paramMap.put("supOperatorName", CommonUtils.createString(deliveryrecordEntity.getSupOperatorName()));
        paramMap.put("supOperatorPhone", CommonUtils.createString(deliveryrecordEntity.getSupOperatorPhone()));
        paramMap.put("supOperatorUserCode", CommonUtils.createString(deliveryrecordEntity.getSupOperatorUserCode()));
        paramMap.put("supOperateTime", CommonUtils.createString(deliveryrecordEntity.getSupOperateTime().getTime()));
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(deliveryrecordEntity.getId(), deliveryrecordBillType, fileSourceType, null);
        if (!fileResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        HashMap files = new HashMap();
        List fileList = (List)fileResp.getData();
        HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
        ArrayList<Long> fileIds = new ArrayList<Long>();
        for (AttachmentVO attach : fileList) {
            fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
            fileIds.add(attach.getId());
        }
        paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
        if (CollectionUtils.isNotEmpty((Collection)fileList)) {
            Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
            fileMap.keySet().stream().forEach(fileKey -> {
                HashMap file = new HashMap(1);
                file.put((String)fileKey, fileMap.get(fileKey));
                files.put(fileKey, file);
            });
        }
        String systemId = deliveryrecordEntity.getSystemId();
        this.logger.info("\u53d1\u9001\u53c2\u6570===url:{},paramMap:[{}],systemId:{},files:{}", new Object[]{PUSH_DELIVERRRECORD_PLAN, paramMap, systemId, files});
        CommonResponse commonResponse = this.systemDataPushService.exchangeDataAndFilesWithThirdSystem(PUSH_DELIVERRRECORD_PLAN, paramMap, systemId, files);
        CommonUtils.checkCommonResponse(commonResponse, this.logger);
        super.saveOrUpdate((Object)deliveryrecordEntity, false);
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u9886\u6599\u5355\u4fe1\u606f\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<");
        return (DeliveryrecordVO)BeanMapper.map((Object)((Object)deliveryrecordEntity), DeliveryrecordVO.class);
    }

    @Override
    public Boolean delSupDeliveryRecord(DeliveryrecordVO vo) {
        this.logger.info("\u8fdb\u5165\u9886\u6599\u8ba1\u5212\u5355\u64a4\u56de\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        if (vo.getSourceId() == null) {
            throw new BusinessException("\u9886\u6599\u5355\u4e0d\u5b58\u5728");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter("eq", (Object)vo.getSourceId()));
        List materialPlanEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)materialPlanEntityList)) {
            throw new BusinessException("\u9886\u6599\u5355\u4e0d\u5b58\u5728");
        }
        DeliveryrecordEntity materialPlanEntity = (DeliveryrecordEntity)((Object)materialPlanEntityList.get(0));
        if (vo.getSystemId() == null || !vo.getSystemId().equals(materialPlanEntity.getSystemId())) {
            throw new BusinessException("\u7cfb\u7edf\u6765\u6e90\u4e0d\u5339\u914d");
        }
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(materialPlanEntity.getId(), deliveryrecordBillType, null, null);
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)fileResp.getData()))) {
            this.logger.info("\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)fileResp.getData()));
            String ids = ((List)fileResp.getData()).stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
            this.attachmentApi.delete(ids);
        }
        boolean flag = super.removeById((Serializable)materialPlanEntity.getId(), false);
        this.logger.info("\u9886\u6599\u8ba1\u5212\u64a4\u56de\u6210\u529f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    @Override
    public Boolean saveDeliveryRecord(HttpServletRequest request, MultipartFile file) {
        this.logger.info("\u8fdb\u5165\u9886\u6599\u5355\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        String plan = request.getParameter(fileSourceType);
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)plan);
        DeliveryrecordVO saveOrUpdateVO = (DeliveryrecordVO)JSON.parseObject((String)plan, (TypeReference)new TypeReference<DeliveryrecordVO>(){}, (Feature[])new Feature[0]);
        DeliveryrecordEntity entity = (DeliveryrecordEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DeliveryrecordEntity.class));
        if (CollectionUtils.isEmpty(entity.getDeliveryrecorddetailEntityList())) {
            throw new BusinessException("\u6750\u6599\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DeliveryrecordEntity materialPlanEntity = (DeliveryrecordEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        if (null != materialPlanEntity) {
            this.logger.info("\u5b58\u5728\u76f8\u540csourceID\u7684\u6570\u636e\uff0c\u539f\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)((Object)materialPlanEntity)));
        }
        entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        entity.setId(IdWorker.getId());
        List<DeliveryrecorddetailEntity> materialPlanDetailList = entity.getDeliveryrecorddetailEntityList();
        for (DeliveryrecorddetailEntity materialPlanDetailEntity : materialPlanDetailList) {
            materialPlanDetailEntity.setSourceId(saveOrUpdateVO.getSourceId());
            materialPlanDetailEntity.setSourceDetailId(materialPlanDetailEntity.getId());
            materialPlanDetailEntity.setId(IdWorker.getId());
            materialPlanDetailEntity.setMid(entity.getId());
        }
        if (null != file) {
            List<Long> attrs = ProMaterialFileUtils.upFile("zjkj-material", entity.getId().toString(), deliveryrecordBillType, file, request, this.logger, FileUtil.getInstance().getBaseHost());
            entity.setAttachIds(attrs);
        }
        boolean flag = super.saveOrUpdate((Object)entity, false);
        this.logger.info("\u4fdd\u5b58\u6210\u529f\uff0c\u9886\u6599\u5355\u4fdd\u5b58\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }
}

