/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.business.supbusiness.bean.OrderDetailEntity;
import com.ejianc.business.supbusiness.bean.OrderEntity;
import com.ejianc.business.supbusiness.enums.CloseFlagEnum;
import com.ejianc.business.supbusiness.enums.OrderDeliverStateEnum;
import com.ejianc.business.supbusiness.enums.OrderReceiveStateEnum;
import com.ejianc.business.supbusiness.mapper.OrderMapper;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.service.IOrderDetailService;
import com.ejianc.business.supbusiness.service.IOrderService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.utils.ProMaterialFileUtils;
import com.ejianc.business.supbusiness.vo.DeliveryVO;
import com.ejianc.business.supbusiness.vo.OrderDetailVO;
import com.ejianc.business.supbusiness.vo.OrderVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderMapper, OrderEntity>
implements IOrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String materialOrderBillType = "EJCBT202408000003";
    private static final String fileSourceType = "materialOrder";

    @Override
    public boolean saveOrder(HttpServletRequest request, MultipartFile file) {
        this.logger.info("\u8fdb\u5165\u8ba2\u5355\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        String order = request.getParameter("order");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)order);
        OrderVO saveOrUpdateVO = (OrderVO)JSON.parseObject((String)order, (TypeReference)new TypeReference<OrderVO>(){}, (Feature[])new Feature[0]);
        OrderEntity entity = (OrderEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OrderEntity.class));
        if (CollectionUtils.isEmpty(entity.getOrderDetailList())) {
            throw new BusinessException("\u6750\u6599\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrderEntity checkEntity = (OrderEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        if (null != checkEntity) {
            this.logger.info("\u5b58\u5728\u76f8\u540csourceID\u7684\u6570\u636e\uff0c\u539f\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)((Object)checkEntity)));
        }
        entity.setOrderFlag(CloseFlagEnum.NORMAL.getCode());
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveState(OrderReceiveStateEnum.WAIT_RECEIVE.getCode());
        if (null != file) {
            List<Long> attrs = ProMaterialFileUtils.upFile(fileSourceType, entity.getId().toString(), materialOrderBillType, file, request, this.logger, FileUtil.getInstance().getBaseHost());
            entity.setAttachIds(attrs);
        }
        boolean flag = super.saveOrUpdate((Object)entity, false);
        this.logger.info("\u4fdd\u5b58\u6210\u529f\uff0c\u8ba2\u5355\u4fdd\u5b58\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    @Override
    public IPage<OrderVO> queryOrderWaitList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("receiveState")) {
            param.getParams().put("receiveState", new Parameter("eq", (Object)OrderReceiveStateEnum.WAIT_RECEIVE.getCode()));
        }
        if (!param.getParams().containsKey("orderFlag")) {
            param.getParams().put("orderFlag", new Parameter("eq", (Object)CloseFlagEnum.NORMAL.getCode()));
        }
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("createTime", "desc");
        }
        return this.queryOrderList(param);
    }

    @Override
    public IPage<OrderVO> queryOrderDeliveredList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("receiveState")) {
            paramMap.put("receiveState", new Parameter("in", Arrays.asList(OrderReceiveStateEnum.PART_RECEIVE.getCode(), OrderReceiveStateEnum.FULL_RECEIVE.getCode())));
        }
        if (!paramMap.containsKey("deliverState")) {
            paramMap.put("deliverState", new Parameter("in", Arrays.asList(OrderDeliverStateEnum.WAIT_DELIVERED.getCode(), OrderDeliverStateEnum.PART_DELIVERED.getCode())));
        }
        if (!param.getParams().containsKey("orderFlag")) {
            param.getParams().put("orderFlag", new Parameter("eq", (Object)CloseFlagEnum.NORMAL.getCode()));
        }
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("createTime", "desc");
        }
        return this.queryOrderList(param);
    }

    private IPage<OrderVO> queryOrderList(QueryParam param) {
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return pageData;
    }

    @Override
    public OrderVO saveOrderDelivered(OrderVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getId() == null) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (saveOrUpdateVO.getReceiveState() == null || OrderReceiveStateEnum.getEnumByStateCode(saveOrUpdateVO.getReceiveState()) == null) {
            throw new BusinessException("\u63a5\u6536\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        OrderEntity entity = (OrderEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        entity.setReceiveReason(saveOrUpdateVO.getReceiveReason());
        entity.setReceiveState(saveOrUpdateVO.getReceiveState());
        if (!OrderReceiveStateEnum.REFUSE_RECEIVE.getCode().equals(saveOrUpdateVO.getReceiveState()) && CollectionUtils.isEmpty((Collection)saveOrUpdateVO.getOrderDetailList())) {
            throw new BusinessException("\u6e05\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<Long, BigDecimal> voReceiveMap = new HashMap<Long, BigDecimal>();
        for (OrderDetailVO detailVO : saveOrUpdateVO.getOrderDetailList()) {
            voReceiveMap.put(detailVO.getId(), detailVO.getReceiveNumsSum());
        }
        if (CollectionUtils.isNotEmpty(entity.getOrderDetailList())) {
            for (OrderDetailEntity detail : entity.getOrderDetailList()) {
                if (OrderReceiveStateEnum.FULL_RECEIVE.getCode().equals(entity.getReceiveState())) {
                    detail.setReceiveNumsSum(detail.getOrderNumSum());
                } else if (OrderReceiveStateEnum.PART_RECEIVE.getCode().equals(entity.getReceiveState())) {
                    detail.setReceiveNumsSum(CommonUtils.setBigDecimalDefaultValue((BigDecimal)voReceiveMap.get(detail.getId())));
                } else if (OrderReceiveStateEnum.REFUSE_RECEIVE.getCode().equals(entity.getReceiveState())) {
                    detail.setReceiveNumsSum(BigDecimal.ZERO);
                }
                detail.setNotShippedNumSum(detail.getReceiveNumsSum());
                detail.setDeliverNumsSum(BigDecimal.ZERO);
            }
            entity.setDeliverState(OrderDeliverStateEnum.WAIT_DELIVERED.getCode());
        }
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u8ba2\u5355\u4fe1\u606f>>>>>>>>>>>>>>>>>>>");
        OrderVO vo = new OrderVO();
        vo.setId(entity.getId());
        vo.setReceiveState(entity.getReceiveState());
        ArrayList<OrderDetailVO> detailList = new ArrayList<OrderDetailVO>();
        for (OrderDetailEntity detail : entity.getOrderDetailList()) {
            OrderDetailVO detailVO = new OrderDetailVO();
            detailVO.setId(detail.getId());
            detailVO.setOrderId(detail.getOrderId());
            detailVO.setReceiveNumsSum(detail.getReceiveNumsSum());
            detailList.add(detailVO);
        }
        vo.setOrderDetailList(detailList);
        String url = "/zjkj-wzxt-web/openapi/order/updateReceived";
        String postData = JSONObject.toJSONString((Object)vo);
        String systemId = entity.getSystemId();
        this.logger.info("\u53d1\u9001\u53c2\u6570===url:{},postData:[{}],systemId:{}", new Object[]{url, postData, systemId});
        CommonResponse commonResponse = this.systemDataPushService.exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
        CommonUtils.checkCommonResponse(commonResponse, this.logger);
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u8ba2\u5355\u4fe1\u606f\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<");
        super.saveOrUpdate((Object)entity, false);
        return vo;
    }

    @Override
    public boolean deleteOrder(OrderVO vo) {
        this.logger.info("\u8fdb\u5165\u65bd\u5de5\u65b9\u64a4\u56de\u8ba2\u5355\u63a5\u53e3>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        if (null == vo.getId()) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OrderEntity checkEntity = (OrderEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (null == checkEntity) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!OrderReceiveStateEnum.WAIT_RECEIVE.getCode().equals(checkEntity.getReceiveState())) {
            throw new BusinessException("\u8ba2\u5355\u5df2\u88ab\u5904\u7406\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(checkEntity.getId(), materialOrderBillType, fileSourceType, null);
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)fileResp.getData()))) {
            this.logger.info("\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)fileResp.getData()));
            String ids = ((List)fileResp.getData()).stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
            this.attachmentApi.delete(ids);
        }
        boolean flag = ((OrderMapper)this.baseMapper).deleteOrder(vo.getId()) != false && this.orderDetailService.deleteOrderDetailByOrderId(vo.getId());
        this.logger.info("\u65bd\u5de5\u65b9\u64a4\u56de\u8ba2\u5355\u6210\u529f<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    @Override
    public boolean updateOrderCloseFlag(OrderVO vo) {
        this.logger.info("\u8fdb\u5165\u65bd\u5de5\u65b9\u5173\u95ed\u8ba2\u5355\u63a5\u53e3>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        if (null == vo.getId()) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OrderEntity orderEntity = (OrderEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (CloseFlagEnum.CLOSE.getCode().equals(orderEntity.getOrderFlag())) {
            throw new BusinessException("\u8ba2\u5355\u5df2\u88ab\u5173\u95ed\uff01");
        }
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(DeliveryEntity::getOrderId, (Object)orderEntity.getId());
        updateWrapper.in(DeliveryEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        updateWrapper.eq(DeliveryEntity::getCloseFlag, (Object)CloseFlagEnum.NORMAL.getCode());
        updateWrapper.set(DeliveryEntity::getCloseFlag, (Object)CloseFlagEnum.CLOSE.getCode());
        this.deliveryService.update((Wrapper)updateWrapper);
        orderEntity.setOrderFlag(CloseFlagEnum.CLOSE.getCode());
        boolean flag = super.saveOrUpdate((Object)orderEntity, false);
        this.logger.info("\u65bd\u5de5\u65b9\u5173\u95ed\u8ba2\u5355\u6210\u529f>>>>>>>>>>>>>>>>>>>");
        return flag;
    }

    @Override
    public OrderVO queryOrderDetail(Long id) {
        OrderEntity orderEntity = (OrderEntity)((Object)super.selectById((Serializable)id));
        OrderVO vo = (OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class);
        if (OrderReceiveStateEnum.FULL_RECEIVE.getCode().equals(vo.getReceiveState()) || OrderReceiveStateEnum.PART_RECEIVE.getCode().equals(vo.getReceiveState())) {
            Map<Long, BigDecimal> deliveryMap = this.deliveryService.sumDeliveredGroupByDetailId(id);
            for (OrderDetailVO detailVO : vo.getOrderDetailList()) {
                BigDecimal deliverNumsSum = CommonUtils.setBigDecimalDefaultValue(deliveryMap.get(detailVO.getId()));
                detailVO.setDeliverNumsSum(deliverNumsSum);
                detailVO.setNotShippedNumSum(detailVO.getReceiveNumsSum().subtract(deliverNumsSum));
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orderId", new Parameter("eq", (Object)id));
            queryParam.getOrderMap().put("createTime", "desc");
            List deliveryEntityList = this.deliveryService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)deliveryEntityList)) {
                List deliveryVOList = BeanMapper.mapList((Iterable)deliveryEntityList, DeliveryVO.class);
                if (CollectionUtils.isNotEmpty((Collection)deliveryVOList)) {
                    for (DeliveryVO deliveryVO : deliveryVOList) {
                        deliveryVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)deliveryVO.getBillState()).getDescription());
                    }
                }
                vo.setDeliveryList(deliveryVOList);
            }
        }
        return vo;
    }

    @Override
    public IPage<OrderVO> queryAllList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("receiveState", new Parameter("in", Arrays.asList(OrderReceiveStateEnum.WAIT_RECEIVE.getCode(), OrderReceiveStateEnum.PART_RECEIVE.getCode(), OrderReceiveStateEnum.FULL_RECEIVE.getCode())));
        if (!param.getParams().containsKey("orderFlag")) {
            param.getParams().put("orderFlag", new Parameter("eq", (Object)CloseFlagEnum.NORMAL.getCode()));
        }
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("createTime", "desc");
        }
        return this.queryOrderList(param);
    }
}

