/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.common.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.supbusiness.common.util.MessageSendHelper;
import com.ejianc.foundation.message.api.ISmsMessageApi;
import com.ejianc.foundation.message.vo.SmsCheckParam;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DESUtils;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sms/"})
public class SmsController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISmsMessageApi smsMessageApi;
    @Autowired
    private MessageSendHelper messageSendHelper;
    @Autowired
    private IUserApi userApi;

    @PostMapping(value={"checkPhoneCode"})
    public CommonResponse<String> checkPhoneCode(@RequestBody SmsCheckParam param) {
        param.setTemplateCode("SMS_195335075");
        return this.smsMessageApi.checkMessage(param);
    }

    @PostMapping(value={"sendPhoneCode"})
    public CommonResponse<String> sendPhoneCode(@RequestBody String param) {
        String result;
        JSONObject paramJson = JSONObject.parseObject((String)param);
        String phone = paramJson.getString("phone");
        String secret = paramJson.getString("secret");
        try {
            secret = URLDecoder.decode(secret, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u5206\u4eab\u8fde\u63a5\u9a8c\u8bc1\u7801\u5f02\u5e38\uff0c\u89e3\u6790\u8fde\u63a5\u53c2\u6570\u5931\u8d25{}\uff0c", (Object)secret, (Object)e);
            return CommonResponse.error((String)"\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff01");
        }
        String params = DESUtils.decrypt((String)secret);
        Map<String, String> paraMap = this.convertToMap(params);
        Integer weakFlag = Integer.valueOf(paraMap.get("weakFlag"));
        if (weakFlag == 0) {
            CommonResponse userResp = this.userApi.findByUserMobile(phone);
            if (!userResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u624b\u673a\u53f7-{}\u67e5\u8be2\u5339\u914d\u7528\u6237\u5931\u8d25\uff0c{}", (Object)phone, (Object)userResp.getMsg());
                return CommonResponse.error((String)"\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5!");
            }
            String supplierTenant = paraMap.get("supplierTenant");
            UserVO user = (UserVO)userResp.getData();
            if (null == user) {
                this.logger.info("\u6839\u636e\u624b\u673a\u53f7-{}\u672a\u67e5\u8be2\u5339\u914d\u7528\u6237\uff0c\u4e14\u5355\u636e\u4e0d\u652f\u6301\u5f31\u534f\u540c");
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u652f\u6301\u5f31\u534f\u540c\uff0c\u6682\u65e0\u6743\u9650\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
            if (!StringUtils.equals((CharSequence)supplierTenant, null != user.getTenantId() ? user.getTenantId().toString() : null)) {
                this.logger.info("\u6839\u636e\u624b\u673a\u53f7\u5bf9\u5e94\u7528\u6237-{}\u975e\u4f9b\u5e94\u5546supplierTenant-{}\u4e0b\u7528\u6237-{}\uff0c\u4e14\u5355\u636e\u4e0d\u652f\u6301\u5f31\u534f\u540c\uff0c\u65e0\u64cd\u4f5c\u6743\u9650\uff01", new Object[]{phone, supplierTenant, JSONObject.toJSONString((Object)user)});
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u652f\u6301\u5f31\u534f\u540c\uff0c\u6682\u65e0\u6743\u9650\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(result = this.messageSendHelper.sendPhoneValidCode(phone, secret)))) {
            return CommonResponse.error((String)result);
        }
        return CommonResponse.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f\uff01");
    }

    private Map<String, String> convertToMap(String params) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] paramPairs = params.split("&");
        String[] tmp = null;
        for (String paramPair : paramPairs) {
            tmp = paramPair.split("=");
            result.put(tmp[0], tmp[1]);
        }
        return result;
    }
}

