package com.ejianc.business.supbusiness.common.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.supbusiness.common.util.BillShareLInkCheckHelper;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;
import java.net.URLDecoder;

/**
 * @author CJ
 * @Description:
 * @date 2022/4/2 17:27
 */
@Controller
@RequestMapping(value = "/commomsupbusiness/")
public class CommonSupBusinessController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private BillShareLInkCheckHelper billShareLInkCheckHelper;

    @Autowired
    private IUserApi userApi;

    /**
     * 生成单据微信端访问地址
     *
     * @param billId 单据Id
     * @param timeInLong 超时时间
     * @param supplierTenant 供应商租户Id
     * @param weakFlag 连接强弱协同标识
     * @param frontUrl 要跳转的前端地址
     * @param secret 签名
     * @param ejcCloudSystemId 系统Id
     * @param code 微信Code
     * @return
     */
    @GetMapping(value = "getBillShareLink")
    public void getBillShareLink(@RequestParam(value = "id") String billId,
                                 @RequestParam(value = "tl") String timeInLong,
                                 @RequestParam(value = "supplierTenant") String supplierTenant,
                                 @RequestParam(value = "weakFlag") String weakFlag,
                                 @RequestParam(value = "frontUrl") String frontUrl,
                                 @RequestParam(value = "secret") String secret,
                                 @RequestParam(value = "ejcCloudSystemId") String ejcCloudSystemId,
                                 @RequestParam(value = "code") String code,
                                 HttpServletResponse response) throws Exception {
        //1、调用API获取用户信息以及 供应商Id
        CommonResponse<JSONObject> supAndUserInfoResp = userApi.querySupplierUserInfoByWXCode(code, ejcCloudSystemId, supplierTenant);
        if(!supAndUserInfoResp.isSuccess()) {
            logger.info("根据用户weixinCode-{}, 私有化平台系统Id-{}, 供应商租户Id-{}查询供应商用户信息失败，{}",
                    code, ejcCloudSystemId, supplierTenant, supAndUserInfoResp.getMsg());
            throw new BusinessException("获取分享连接失败，查询当前用户在供应商下的信息失败！");
        }
        JSONObject supAndUserInfoJson = supAndUserInfoResp.getData();
        Long supplierId = Long.valueOf(supAndUserInfoJson.getString("supplierId"));

        //2、验证连接是否被篡改，是否超时
        String checkMsg = billShareLInkCheckHelper.isShareLinkValid(timeInLong, billId, supplierId.toString(), weakFlag, secret, supplierTenant);
        if(StringUtils.isNotBlank(checkMsg)) {
            throw new BusinessException(checkMsg);
        }

        //3、验证用户是否具有操作权限:  有权限-y,无权限-n
        String oprFlag = "y";
        UserVO user = JSONObject.parseObject(supAndUserInfoJson.getString("userInfo"), UserVO.class);
        //验证当前用户
        if("0".equals(weakFlag)) {
            //不支持若协同
            if(null == user) {
                logger.info("根据手机号-{}未查询匹配用户，且单据不支持弱协同");
                oprFlag = "n";
            }
            //2、判断当前用户是否为供应商下租户
            if (!StringUtils.equals(supplierTenant, (null != user.getTenantId() ? user.getTenantId().toString() : null))) {
                logger.info("根据用户id-{}非供应商supplierTenant-{}下用户-{}，且单据不支持弱协同，无操作权限！", user.getId(), supplierTenant, JSONObject.toJSONString(user));
                oprFlag = "n";
            }
        }

        //4、拼接访问地址
        StringBuffer newUrl = new StringBuffer(BASE_HOST);
        newUrl.append(URLDecoder.decode(frontUrl, "UTF-8"))
                .append("?id=")
                .append(billId)
                .append("&tl=")
                .append(timeInLong)
                .append("&supplierTenant=")
                .append(supplierTenant)
                .append("&weakFlag=")
                .append(weakFlag)
        .append("&oprFlag=").append(oprFlag);

        //5、重定向到新的访问地址
        response.sendRedirect(newUrl.toString());
    }

}
