package com.ejianc.business.supbusiness.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.business.supbusiness.enums.CheckStateEnum;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.vo.DeliveryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消耗材送货单
 *
 * @author generator
 */
@Controller
@RequestMapping("delivery")
@Api(value = "消耗材送货单", tags = {"消耗材送货单"})
public class DeliveryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDeliveryService service;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody DeliveryVO saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", service.saveDeliver(saveOrUpdateVO));
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(@RequestParam Long id) {
        DeliveryEntity entity = service.selectById(id);
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DeliveryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DeliveryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.queryDeliverList(param));
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<DeliveryVO> page = service.queryDeliverList(param);
        List<DeliveryVO> list = page.getRecords();
        for (DeliveryVO deliveryVO : list) {
            deliveryVO.setCheckStatusName(CheckStateEnum.getEnumByStatus(deliveryVO.getCheckStatus()).getStatusName());
            deliveryVO.setCloseFlagName( null == deliveryVO.getCloseFlag() || deliveryVO.getCloseFlag() == 0 ? "否" : "是");
            deliveryVO.setBillStateName(BillStateEnum.getEnumByStateCode(deliveryVO.getBillState()).getDescription());
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Delivery-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refMaterialDeliveryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> refMaterialDeliveryData(@RequestParam Integer pageNumber,
                                                                             @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DeliveryEntity> page = service.queryPage(param, false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeliveryVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("修改送货单状态")
    @RequestMapping(value = "/saveMaterialDeliveryState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> saveMaterialDeliveryState(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DeliveryVO saveOrUpdateVO){
        return CommonResponse.success("修改送货单状态成功！", service.updateDeliverState(saveOrUpdateVO));
    }

    @ApiOperation("初始化送货单详情")
    @RequestMapping(value = "/queryInitDelivery", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryInitDelivery(@RequestParam Long orderId) {
        return CommonResponse.success("初始化成功！",service.queryInitDelivery(orderId));
    }

    @ApiOperation("提交推送数据方法")
    @RequestMapping(value = "/saveCommitAfter", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryVO> saveCommitAfter(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody DeliveryVO saveOrUpdateVO) {
        return CommonResponse.success("发送成功！",service.saveCommitAfter(saveOrUpdateVO.getId()));
    }

    /**
     *更新称重口令
     * @return
     */
    @RequestMapping(value = "/updateWeighkey", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> updateWeighkey(Integer saveType, Long deliveryId) {
        return CommonResponse.success("更新称重口令成功！", service.updateWeighkey(saveType, deliveryId));
    }

    /**
     * 校验口令是否可用
     * @param weighkey
     * @return
     */
    @RequestMapping(value = "/checkWeighkey", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkWeighkey(@RequestParam("weighkey") String weighkey) {
        return CommonResponse.success("校验口令是否可用成功！", service.checkWeighkey(weighkey));
    }

    /**
     *根据口令查询送货详情
     * @param weighkey
     * @return
     */
    @RequestMapping(value = "/getDetailByWeighkey", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> getDetailByWeighkey(@RequestParam("weighkey") String weighkey) {
        return CommonResponse.success("根据口令查询送货详情成功！", service.getDetailByWeighkey(weighkey));
    }
}
