package com.ejianc.business.supbusiness.enums;

/**
 * 乙方签字状态
 */
public enum CheckSupplierSignStatusEnum {

    未签字(0, "未签字"),
    已签字(1, "已签字");

    private Integer code;

    private String description;

    CheckSupplierSignStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 获取状态
     *
     * @return 状态
     */
    public Integer getCode() {
        return this.code;
    }

    /**
     * 获取状态注释
     *
     * @return 状态注释
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 根据状态获取状态枚举
     *
     * @param planState 状态
     * @return 状态枚举
     */
    public static CheckSupplierSignStatusEnum getEnumByStateCode(Integer planState) {
        for (CheckSupplierSignStatusEnum enu : CheckSupplierSignStatusEnum.values()) {
            if (enu.getCode().equals(planState)) return enu;
        }
        return null;
    }

    /**
     * 根据状态获取状态注释
     *
     * @param planState 状态
     * @return 状态注释
     */
    public static String getDescriptionByStateCode(Integer planState) {
        CheckSupplierSignStatusEnum enu = getEnumByStateCode(planState);
        if (enu != null) return enu.getDescription();
        return null;
    }

}

