package com.ejianc.business.supbusiness.mapper;

import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 消耗材送货单
 *
 * @author generator
 */
@Mapper
public interface DeliveryMapper extends BaseCrudMapper<DeliveryEntity> {

    @Select("select weighkey from ejc_wzxt_delivery where weighkey_create_date <= CURRENT_TIMESTAMP()" +
            " and weighkey_unused_date >= CURRENT_TIMESTAMP() and close_flag=0")
    List<String> getUsedWeighkey();

    @Select("select id from ejc_wzxt_delivery where weighkey= #{weighkey} and weighkey_create_date <= CURRENT_TIMESTAMP()" +
            " and weighkey_unused_date >= CURRENT_TIMESTAMP() and close_flag=0")
    List<String> getListByWeighkey(@Param("weighkey") String weighkey);
}
