package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.supbusiness.bean.CheckDetailEntity;
import com.ejianc.business.supbusiness.bean.CheckEntity;
import com.ejianc.business.supbusiness.constant.InteractiveConstants;
import com.ejianc.business.supbusiness.enums.CheckSupplierSignStatusEnum;
import com.ejianc.business.supbusiness.mapper.CheckMapper;
import com.ejianc.business.supbusiness.service.ICheckService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.utils.SendMsgUtils;
import com.ejianc.business.supbusiness.vo.CheckDbVO;
import com.ejianc.business.supbusiness.vo.CheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材验收单
 *
 * @author generator
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 单据类型
     */
    private static final String billType = "EJCBT202408000005";

    private static final String checkFileSourceType = "materialCheck";
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Value("${weixinMsg.checkTmp}")
    private String WEIXIN_CHECK_TMP;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;


    /**
     * 保存验收单
     *
     * @param request 请求信息
     * @return 保存结果
     */
    @Override
    public boolean saveCheck(HttpServletRequest request) {
        logger.info("进入验收单保存接口>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String files = request.getParameter("files");
        logger.info("接收到数据transData：{}，nameSourceTypeMapping：{}", transData, null);
        logger.error("接收到数据files" + files);
        // 转换
        CheckDbVO tbVO = JSONObject.parseObject(transData, CheckDbVO.class);

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, tbVO.getSourceId()));
        List<CheckEntity> checkEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(checkEntityList)) {
            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(checkEntityList));
//            throw new BusinessException("验收单已在存在！");
        }
        CheckEntity saveEntity = BeanMapper.map(tbVO, CheckEntity.class);
        saveEntity.setCheckDetailList(BeanMapper.mapList(tbVO.getCheckDetailList(),
                CheckDetailEntity.class));
        saveEntity.setSupplierSignStatus(CheckSupplierSignStatusEnum.未签字.getCode());
        List<Long> attchIdsList = new ArrayList<>();
        if (StringUtils.isNotBlank(files)) {
            List<UploadFileForNetParam> fileList = JSON.parseArray(request.getParameter("files"), UploadFileForNetParam.class);
            for (UploadFileForNetParam param : fileList) {
                param.setBillType(billType);
                param.setSourceId(saveEntity.getId());
                param.setTenantId(InvocationInfoProxy.getTenantid());
                attchIdsList.addAll(param.getNewFileIds());
                attachmentApi.uploadFileFormNet(param);
            }
        }

        saveEntity.setAttachIds(attchIdsList);
        boolean flag = super.saveOrUpdate(saveEntity, false);
        logger.info("保存成功，验收单保存结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");

        sendWeChatMsg(saveEntity);

        return flag;
    }

    /**
     * 发送微信消息
     */
    private void sendWeChatMsg(CheckEntity checkEntity) {
        String systemId = checkEntity.getSystemId();
        CommonResponse<Map<Long, List<Long>>> commonResponse = cooperateEnterpriseApi
                .getCooperateSupplierSuperUserIdByEnterpriseId(systemId);
        logger.info("{}查询供应商数据结果：{}", systemId, JSONObject.toJSONString(commonResponse));
        if (!commonResponse.isSuccess()) {
            throw new BusinessException("查询供方列表失败！");
        }
        Map<Long, List<Long>> map = commonResponse.getData();

        if (map.isEmpty()) {
            logger.info("查询信息为空！");
            return;
        }
        logger.info("------开始发送微信消息----");
        logger.info("发送消息数量：{}；消息模板：{}", map.size(), WEIXIN_CHECK_TMP);
        // 循环处理发送消息
        for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
            Long tenantId = entry.getKey();
            List<Long> userLongList = entry.getValue();
            if (CollectionUtils.isEmpty(userLongList) || !InvocationInfoProxy.getTenantid().equals(tenantId)) {
                logger.info("租户{}下查询用户为空", tenantId);
                continue;
            }
            String subject = "您有一条新的验收单信息";
            String content = "验收单编号：" + checkEntity.getBillCode() + "，项目名称：" + checkEntity.getProjectName();
            HashMap<String, Object> weixinMap = new HashMap<>();
            String pcUrl = BASE_HOST + "zjkj-supbusiness-frontend/#/acceptList/card?id=" + checkEntity.getId();
            String mobileUrl = BASE_HOST + "zjkj-supbusiness-mobile/#/check/card?id=" + checkEntity.getId() + "&userid={userid}";
            String wechatUrl = BASE_HOST + "zjkj-supbusiness-mobile/#/check/card?id=" + checkEntity.getId() + "&openid={openid}";
            weixinMap.put("character_string6", checkEntity.getBillCode()); // 订单号
            weixinMap.put("thing3", checkEntity.getProjectName()); // 收货单位
            weixinMap.put("time2", new SimpleDateFormat("yyyy-MM-dd").format(checkEntity.getCheckDate())); // 收货时间

            List<String> userList = userLongList.stream().map(String::valueOf).collect(Collectors.toList());

            new SendMsgUtils().sendWeiXinMsg(userList, subject, content, tenantId.toString(),
                    weixinMap, WEIXIN_CHECK_TMP, mobileUrl, pcUrl, wechatUrl, pushMessageApi);
        }
        logger.info("------发送微信消息结束----");
    }

    /**
     * 删除验收单
     *
     * @param vo 需要删除的验收单
     * @return 删除结果
     */
    @Override
    public boolean deleteCheck(CheckVO vo) {
        logger.info("进入验收单撤回接口>>>>>>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", JSONObject.toJSONString(vo));
        if (vo.getSourceId() == null) {
            throw new BusinessException("验收单不存在");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, vo.getSourceId()));
        List<CheckEntity> checkEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(checkEntityList)) {
            throw new BusinessException("验收单不存在");
        }
        CheckEntity checkEntity = checkEntityList.get(0);
        if (vo.getSystemId() == null || !vo.getSystemId().equals(checkEntity.getSystemId())) {
            throw new BusinessException("系统来源不匹配");
        }
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(checkEntity.getId(), billType, null, null);
        // 查询成功并有相应的文件
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
                    .collect(Collectors.joining(","));
            attachmentApi.delete(ids);
        }
        boolean flag = super.removeById(checkEntity.getId(), false);
        logger.info("验收单撤回成功<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    /**
     * 验收单签字
     *
     * @param checkVO 需要签字的验收单
     * @return 签字结果
     */
    @Override
    public CheckVO saveSupplierSign(CheckVO checkVO) {
        logger.info("开始通知施工方验收单信息>>>>>>>>>>>>>>>>>>>");
        CheckEntity saveEntity = super.selectById(checkVO.getId());
        saveEntity.setSupplierSignStatus(CheckSupplierSignStatusEnum.已签字.getCode());
        saveEntity.setSupOperateTime(new Date());
        saveEntity.setSupOperatorName(checkVO.getSupOperatorName());
        saveEntity.setSupOperatorPhone(checkVO.getSupOperatorPhone());
        saveEntity.setSupOperatorUserCode(checkVO.getSupOperatorUserCode());
        Map<String, String> paramMap = new HashMap<>();
//        MaterialCheckTbVO tbVO = BeanMapper.map(saveEntity, MaterialCheckTbVO.class);
//        tbVO.setCheckDetailList(BeanMapper.mapList(saveEntity.getMaterialCheckDetailList(), MaterialCheckDetailTbVO.class));
//        paramMap.put("transData", JSONObject.toJSONString(tbVO));

        paramMap.put("billId", CommonUtils.createString(saveEntity.getSourceId()));
        paramMap.put("supOperatorName", CommonUtils.createString(saveEntity.getSupOperatorName()));
        paramMap.put("supOperatorPhone", CommonUtils.createString(saveEntity.getSupOperatorPhone()));
        paramMap.put("supOperatorUserCode", CommonUtils.createString(saveEntity.getSupOperatorUserCode()));
        paramMap.put("supOperateTime", CommonUtils.createString(saveEntity.getSupOperateTime().getTime()));

        // 查询文件信息
        //查询单据附件信息并下载
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(saveEntity.getId(), billType, checkFileSourceType, null);
        if (!fileResp.isSuccess()) {
            throw new BusinessException("查询文件信息失败！");
        }
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        List<AttachmentVO> fileList = fileResp.getData();

        //Map<fileName, fileSourceType>
        Map<String, String> fileSourceTypeMap = new HashMap<>();
        List<Long> fileIds = new ArrayList<>();

        //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
        for (AttachmentVO attach : fileList) {
            fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
            fileIds.add(attach.getId());
        }
        paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
        //当前单据携带有附件信息
        if (CollectionUtils.isNotEmpty(fileList)) {
            Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
            fileMap.keySet().stream().forEach(fileKey -> {
                Map<String, InputStream> file = new HashMap<>(1);
                file.put(fileKey, fileMap.get(fileKey));
                files.put(fileKey, file);
            });
        }
//        String url = pushMaterialCheck;
        String url = InteractiveConstants.PUSH_MATERIAL_CHECK;
        String systemId = saveEntity.getSystemId();
        logger.info("发送参数===url:{},paramMap:[{}],systemId:{},files:{}", url, paramMap, systemId, files);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataAndFilesWithThirdSystem(url, paramMap, systemId, files);
        CommonUtils.checkCommonResponse(commonResponse, logger);
        super.saveOrUpdate(saveEntity, false);
        logger.info("通知施工方验收单信息结束<<<<<<<<<<<<<<<<<<<<<<");
        return BeanMapper.map(saveEntity, CheckVO.class);
    }

    /**
     * 根据sourceId查询验收单
     *
     * @param sourceId sourceId
     * @return 验收单明细
     */
    @Override
    public CheckVO queryCheckBySourceId(String sourceId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
        List<CheckEntity> checkEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(checkEntityList)) return null;
        CheckEntity checkEntity = super.selectById(checkEntityList.get(0).getId());
        return BeanMapper.map(checkEntity, CheckVO.class);
    }


}
