package com.ejianc.business.supbusiness.service.impl;

import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.business.supbusiness.bean.OrderEntity;
import com.ejianc.business.supbusiness.enums.CloseFlagEnum;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.service.IOrderService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("delivery")
public class DeliveryBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(getClass());
	@Autowired
	private IOrderService orderService;

	@Autowired
	private IDeliveryService service;


	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	;

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("无法撤回！");
	}

	;

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	;

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.error("无法撤回！");
	}

	;

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		DeliveryEntity deliveryEntity = service.selectById(billId);
		OrderEntity orderEntity = orderService.selectById(deliveryEntity.getOrderId());
		if (CloseFlagEnum.CLOSE.getCode().equals(orderEntity.getOrderFlag())) {
			return CommonResponse.error("该送货单对应订单已关闭，不允许提交!");
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)
				|| BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
			logger.info("---------------------开始终审审核完回调-------------------");
			service.saveCommitAfter(billId);
			logger.info("---------------------结束终审审核完回调-------------------");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("无法撤回！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		/**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		 if(!resp.isSuccess()){
		 return CommonResponse.error("无法撤回！"+resp.getMsg());
		 }*/
		return CommonResponse.success();
	}

}
