/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.common.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.supbusiness.common.util.BillShareLInkCheckHelper;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/commomsupbusiness/"})
public class CommonSupBusinessController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private BillShareLInkCheckHelper billShareLInkCheckHelper;
    @Autowired
    private IUserApi userApi;

    @GetMapping(value={"getBillShareLink"})
    public void getBillShareLink(@RequestParam(value="id") String billId, @RequestParam(value="tl") String timeInLong, @RequestParam(value="supplierTenant") String supplierTenant, @RequestParam(value="weakFlag") String weakFlag, @RequestParam(value="frontUrl") String frontUrl, @RequestParam(value="secret") String secret, @RequestParam(value="ejcCloudSystemId") String ejcCloudSystemId, @RequestParam(value="code") String code, HttpServletResponse response) throws Exception {
        CommonResponse supAndUserInfoResp = this.userApi.querySupplierUserInfoByWXCode(code, ejcCloudSystemId, supplierTenant);
        if (!supAndUserInfoResp.isSuccess()) {
            this.logger.info("\u6839\u636e\u7528\u6237weixinCode-{}, \u79c1\u6709\u5316\u5e73\u53f0\u7cfb\u7edfId-{}, \u4f9b\u5e94\u5546\u79df\u6237Id-{}\u67e5\u8be2\u4f9b\u5e94\u5546\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c{}", new Object[]{code, ejcCloudSystemId, supplierTenant, supAndUserInfoResp.getMsg()});
            throw new BusinessException("\u83b7\u53d6\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff0c\u67e5\u8be2\u5f53\u524d\u7528\u6237\u5728\u4f9b\u5e94\u5546\u4e0b\u7684\u4fe1\u606f\u5931\u8d25\uff01");
        }
        JSONObject supAndUserInfoJson = (JSONObject)supAndUserInfoResp.getData();
        Long supplierId = Long.valueOf(supAndUserInfoJson.getString("supplierId"));
        String checkMsg = this.billShareLInkCheckHelper.isShareLinkValid(timeInLong, billId, supplierId.toString(), weakFlag, secret, supplierTenant);
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            throw new BusinessException(checkMsg);
        }
        String oprFlag = "y";
        UserVO user = (UserVO)JSONObject.parseObject((String)supAndUserInfoJson.getString("userInfo"), UserVO.class);
        if ("0".equals(weakFlag)) {
            if (null == user) {
                this.logger.info("\u6839\u636e\u624b\u673a\u53f7-{}\u672a\u67e5\u8be2\u5339\u914d\u7528\u6237\uff0c\u4e14\u5355\u636e\u4e0d\u652f\u6301\u5f31\u534f\u540c");
                oprFlag = "n";
            }
            if (!StringUtils.equals((CharSequence)supplierTenant, null != user.getTenantId() ? user.getTenantId().toString() : null)) {
                this.logger.info("\u6839\u636e\u7528\u6237id-{}\u975e\u4f9b\u5e94\u5546supplierTenant-{}\u4e0b\u7528\u6237-{}\uff0c\u4e14\u5355\u636e\u4e0d\u652f\u6301\u5f31\u534f\u540c\uff0c\u65e0\u64cd\u4f5c\u6743\u9650\uff01", new Object[]{user.getId(), supplierTenant, JSONObject.toJSONString((Object)user)});
                oprFlag = "n";
            }
        }
        StringBuffer newUrl = new StringBuffer(this.BASE_HOST);
        newUrl.append(URLDecoder.decode(frontUrl, "UTF-8")).append("?id=").append(billId).append("&tl=").append(timeInLong).append("&supplierTenant=").append(supplierTenant).append("&weakFlag=").append(weakFlag).append("&oprFlag=").append(oprFlag);
        response.sendRedirect(newUrl.toString());
    }
}

