/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.supbusiness.bean.CheckDetailEntity;
import com.ejianc.business.supbusiness.bean.CheckEntity;
import com.ejianc.business.supbusiness.enums.CheckSupplierSignStatusEnum;
import com.ejianc.business.supbusiness.mapper.CheckMapper;
import com.ejianc.business.supbusiness.service.ICheckService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.utils.SendMsgUtils;
import com.ejianc.business.supbusiness.vo.CheckDbVO;
import com.ejianc.business.supbusiness.vo.CheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String billType = "EJCBT202408000005";
    private static final String checkFileSourceType = "materialCheck";
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${weixinMsg.checkTmp}")
    private String WEIXIN_CHECK_TMP;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;

    @Override
    public boolean saveCheck(HttpServletRequest request) {
        this.logger.info("\u8fdb\u5165\u9a8c\u6536\u5355\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String files = request.getParameter("files");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636etransData\uff1a{}\uff0cnameSourceTypeMapping\uff1a{}", (Object)transData, null);
        this.logger.error("\u63a5\u6536\u5230\u6570\u636efiles" + files);
        CheckDbVO tbVO = (CheckDbVO)JSONObject.parseObject((String)transData, CheckDbVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter("eq", (Object)tbVO.getSourceId()));
        List checkEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)checkEntityList)) {
            this.logger.info("\u5b58\u5728\u76f8\u540csourceID\u7684\u6570\u636e\uff0c\u539f\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)checkEntityList));
        }
        CheckEntity saveEntity = (CheckEntity)((Object)BeanMapper.map((Object)tbVO, CheckEntity.class));
        saveEntity.setId(IdWorker.getId());
        saveEntity.setCheckDetailList(BeanMapper.mapList((Iterable)tbVO.getCheckDetailList(), CheckDetailEntity.class));
        saveEntity.setSupplierSignStatus(CheckSupplierSignStatusEnum.\u672a\u7b7e\u5b57.getCode());
        ArrayList attchIdsList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)files)) {
            List fileList = JSON.parseArray((String)request.getParameter("files"), UploadFileForNetParam.class);
            for (UploadFileForNetParam param : fileList) {
                param.setBillType(billType);
                param.setSourceId(saveEntity.getId());
                param.setTenantId(InvocationInfoProxy.getTenantid());
                attchIdsList.addAll(param.getNewFileIds());
                CommonResponse response = this.attachmentApi.uploadFileFormNet(param);
                if (response.isSuccess()) continue;
                this.logger.error("uploadFileFormNet result is " + JSONObject.toJSONString((Object)response));
            }
        }
        saveEntity.setAttachIds(attchIdsList);
        boolean flag = super.saveOrUpdate((Object)saveEntity, false);
        this.logger.info("\u4fdd\u5b58\u6210\u529f\uff0c\u9a8c\u6536\u5355\u4fdd\u5b58\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        this.sendWeChatMsg(saveEntity);
        return flag;
    }

    private void sendWeChatMsg(CheckEntity checkEntity) {
        String systemId = checkEntity.getSystemId();
        CommonResponse commonResponse = this.cooperateEnterpriseApi.getCooperateSupplierSuperUserIdByEnterpriseId(systemId);
        this.logger.info("{}\u67e5\u8be2\u4f9b\u5e94\u5546\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)systemId, (Object)JSONObject.toJSONString((Object)commonResponse));
        if (!commonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u4f9b\u65b9\u5217\u8868\u5931\u8d25\uff01");
        }
        Map map = (Map)commonResponse.getData();
        if (map.isEmpty()) {
            this.logger.info("\u67e5\u8be2\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return;
        }
        this.logger.info("------\u5f00\u59cb\u53d1\u9001\u5fae\u4fe1\u6d88\u606f----");
        this.logger.info("\u53d1\u9001\u6d88\u606f\u6570\u91cf\uff1a{}\uff1b\u6d88\u606f\u6a21\u677f\uff1a{}", (Object)map.size(), (Object)this.WEIXIN_CHECK_TMP);
        for (Map.Entry entry : map.entrySet()) {
            Long tenantId = (Long)entry.getKey();
            List userLongList = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)userLongList) || !InvocationInfoProxy.getTenantid().equals(tenantId)) {
                this.logger.info("\u79df\u6237{}\u4e0b\u67e5\u8be2\u7528\u6237\u4e3a\u7a7a", (Object)tenantId);
                continue;
            }
            String subject = "\u60a8\u6709\u4e00\u6761\u65b0\u7684\u9a8c\u6536\u5355\u4fe1\u606f";
            String content = "\u9a8c\u6536\u5355\u7f16\u53f7\uff1a" + checkEntity.getBillCode() + "\uff0c\u9879\u76ee\u540d\u79f0\uff1a" + checkEntity.getProjectName();
            HashMap<String, Object> weixinMap = new HashMap<String, Object>();
            String pcUrl = this.BASE_HOST + "zjkj-supbusiness-frontend/#/acceptList/card?id=" + checkEntity.getId();
            String mobileUrl = this.BASE_HOST + "zjkj-supbusiness-mobile/#/check/card?id=" + checkEntity.getId() + "&userid={userid}";
            String wechatUrl = this.BASE_HOST + "zjkj-supbusiness-mobile/#/check/card?id=" + checkEntity.getId() + "&openid={openid}";
            weixinMap.put("character_string6", checkEntity.getBillCode());
            weixinMap.put("thing3", checkEntity.getProjectName());
            weixinMap.put("time2", new SimpleDateFormat("yyyy-MM-dd").format(checkEntity.getCheckDate()));
            List<String> userList = userLongList.stream().map(String::valueOf).collect(Collectors.toList());
            new SendMsgUtils().sendWeiXinMsg(userList, subject, content, tenantId.toString(), weixinMap, this.WEIXIN_CHECK_TMP, mobileUrl, pcUrl, wechatUrl, this.pushMessageApi);
        }
        this.logger.info("------\u53d1\u9001\u5fae\u4fe1\u6d88\u606f\u7ed3\u675f----");
    }

    @Override
    public boolean deleteCheck(CheckVO vo) {
        this.logger.info("\u8fdb\u5165\u9a8c\u6536\u5355\u64a4\u56de\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        if (vo.getSourceId() == null) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5b58\u5728");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter("eq", (Object)vo.getSourceId()));
        List checkEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)checkEntityList)) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5b58\u5728");
        }
        CheckEntity checkEntity = (CheckEntity)((Object)checkEntityList.get(0));
        if (vo.getSystemId() == null || !vo.getSystemId().equals(checkEntity.getSystemId())) {
            throw new BusinessException("\u7cfb\u7edf\u6765\u6e90\u4e0d\u5339\u914d");
        }
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(checkEntity.getId(), billType, null, null);
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)fileResp.getData()))) {
            this.logger.info("\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)fileResp.getData()));
            String ids = ((List)fileResp.getData()).stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
            this.attachmentApi.delete(ids);
        }
        boolean flag = super.removeById((Serializable)checkEntity.getId(), false);
        this.logger.info("\u9a8c\u6536\u5355\u64a4\u56de\u6210\u529f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    @Override
    public CheckVO saveSupplierSign(CheckVO checkVO) {
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u9a8c\u6536\u5355\u4fe1\u606f>>>>>>>>>>>>>>>>>>>");
        CheckEntity saveEntity = (CheckEntity)((Object)super.selectById((Serializable)checkVO.getId()));
        saveEntity.setSupplierSignStatus(CheckSupplierSignStatusEnum.\u5df2\u7b7e\u5b57.getCode());
        saveEntity.setSupOperateTime(new Date());
        saveEntity.setSupOperatorName(checkVO.getSupOperatorName());
        saveEntity.setSupOperatorPhone(checkVO.getSupOperatorPhone());
        saveEntity.setSupOperatorUserCode(checkVO.getSupOperatorUserCode());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("billId", CommonUtils.createString(saveEntity.getSourceId()));
        paramMap.put("supOperatorName", CommonUtils.createString(saveEntity.getSupOperatorName()));
        paramMap.put("supOperatorPhone", CommonUtils.createString(saveEntity.getSupOperatorPhone()));
        paramMap.put("supOperatorUserCode", CommonUtils.createString(saveEntity.getSupOperatorUserCode()));
        paramMap.put("supOperateTime", CommonUtils.createString(saveEntity.getSupOperateTime().getTime()));
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(saveEntity.getId(), billType, checkFileSourceType, null);
        if (!fileResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        HashMap files = new HashMap();
        List fileList = (List)fileResp.getData();
        HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
        ArrayList<Long> fileIds = new ArrayList<Long>();
        for (AttachmentVO attach : fileList) {
            fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
            fileIds.add(attach.getId());
        }
        paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
        if (CollectionUtils.isNotEmpty((Collection)fileList)) {
            Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
            fileMap.keySet().stream().forEach(fileKey -> {
                HashMap file = new HashMap(1);
                file.put((String)fileKey, fileMap.get(fileKey));
                files.put(fileKey, file);
            });
        }
        String url = "/zjkj-wzxt-web/openapi/check/supSignSync";
        String systemId = saveEntity.getSystemId();
        this.logger.info("\u53d1\u9001\u53c2\u6570===url:{},paramMap:[{}],systemId:{},files:{}", new Object[]{url, paramMap, systemId, files});
        CommonResponse commonResponse = this.systemDataPushService.exchangeDataAndFilesWithThirdSystem(url, paramMap, systemId, files);
        CommonUtils.checkCommonResponse(commonResponse, this.logger);
        super.saveOrUpdate((Object)saveEntity, false);
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u9a8c\u6536\u5355\u4fe1\u606f\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<");
        return (CheckVO)BeanMapper.map((Object)((Object)saveEntity), CheckVO.class);
    }

    @Override
    public CheckVO queryCheckBySourceId(String sourceId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter("eq", (Object)sourceId));
        List checkEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)checkEntityList)) {
            return null;
        }
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)((CheckEntity)((Object)checkEntityList.get(0))).getId()));
        return (CheckVO)BeanMapper.map((Object)((Object)checkEntity), CheckVO.class);
    }
}

