package com.ejianc.business.financeintegration.ZzyjTradePayApply.api;

import com.ejianc.business.financeintegration.ZzyjTradePayApply.hystrix.ZzyjTradePayApplyHystrix;
import com.ejianc.business.financeintegration.ZzyjTradePayApply.vo.ZzyjTradePayApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * PM付款申请单API
 */
@FeignClient(name = "zzyj-financeintegration-web", url = "${common.env.feign-client-url}", path = "zzyj-financeintegration-web", fallback = ZzyjTradePayApplyHystrix.class)
public interface IZzyjTradePayApplyApi {

    // 付款申请生效
    @PostMapping(value = "/api/ZzyjTradePayApply/takeEffect")
    public CommonResponse<ZzyjTradePayApplyVO> takeEffect(@RequestBody ZzyjTradePayApplyVO vo);

    // 付款申请弃审/关闭
    @PostMapping(value = "/api/ZzyjTradePayApply/abandonOrClose")
    public CommonResponse<ZzyjTradePayApplyVO> abandonOrClose(@RequestBody ZzyjTradePayApplyVO vo);

    // 付款申请核销
    @PostMapping(value = "/api/ZzyjTradePayApply/writeOff")
    public CommonResponse<ZzyjTradePayApplyVO> writeOff(@RequestBody ZzyjTradePayApplyVO vo);

    @PostMapping(value = "/api/ZzyjTradePayApply/dailyFinanceInfo")
    public CommonResponse<List<Map<String, Object>>> dailyFinanceInfo(@RequestBody String dateStr);

}
