package com.ejianc.business.financeintegration.PMPayApply.api;

import com.ejianc.business.financeintegration.PMPayApply.hystrix.PMZZCRKDHystrix;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMZZCCZDVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMZZCDBDVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMZZCRKDVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * PM周转材入库单
 */
@FeignClient(name = "zzyj-financeintegration-web", url = "${common.env.feign-client-url}", path = "zzyj-financeintegration-web", fallback = PMZZCRKDHystrix.class)
public interface IPMZZCRKDApi {

    // 批量保存
    @PostMapping(value = "/api/PMZzcrkd/saveOrUpdate")
    public CommonResponse<PMZZCRKDVO> saveOrUpdate(@RequestBody List<PMZZCRKDVO> vo);

    // 批量删除
    @PostMapping(value = "/api/PMZzcrkd/delete")
    public CommonResponse<Boolean> delete(@RequestBody List<String> list);

    // 批量保存调拨单
    @PostMapping(value = "/api/PMZzcdbd/saveDbd")
    public CommonResponse<PMZZCDBDVO> saveDbd(@RequestBody List<PMZZCDBDVO> vo);

    // 批量保存处置单
    @PostMapping(value = "/api/PMZzcczd/saveCzd")
    public CommonResponse<PMZZCCZDVO> saveCzd(@RequestBody List<PMZZCCZDVO> vo);

    // 批量删除
    @PostMapping(value = "/api/PMZzcczd/deleteCzd")
    public CommonResponse<Boolean> deleteCzd(@RequestBody List<String> list);
}
