package com.ejianc.business.financeintegration.PMPayApply.controller.api;

import com.ejianc.business.financeintegration.PMPayApply.service.IPMPayApplyService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * PM支付申请
 *
 * @author generator
 */
@RestController
@RequestMapping
public class PMPayApplyApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMPayApplyService pmPayService;

    // 付款申请生效
    @PostMapping(value = "/api/PMPayApply/takeEffect")
    public CommonResponse<PMPayApplyVO> takeEffect(@RequestBody PMPayApplyVO pmPayApplyVO) {
        return pmPayService.takeEffect(pmPayApplyVO);
    }

    // 付款申请弃审/关闭
    @PostMapping(value = "/api/PMPayApply/abandonOrClose")
    public CommonResponse<PMPayApplyVO> abandonOrClose(@RequestBody PMPayApplyVO pmPayApplyVO) {
        return pmPayService.abandonOrClose(pmPayApplyVO);
    }

    // 付款申请核销
    @PostMapping(value = "/api/PMPayApply/writeOff")
    public CommonResponse<PMPayApplyVO> writeOff(@RequestBody PMPayApplyVO pmPayApplyVO) {
        return pmPayService.writeOff(pmPayApplyVO);
    }

}
