package com.ejianc.business.financeintegration.PMPayApply.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMGDZCSJEntity;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMGDZCSJService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMGDZCSJVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 固定资产摊销
 *
 * @author sunyj
 */
@RestController
@RequestMapping("pmgdzcsj")
public class PMGDZCSJController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMGDZCSJService service;


    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PMGDZCSJVO>> queryDetail(@RequestParam String projectId, @RequestParam List<String> period) {
        List<PMGDZCSJVO> listRes = new ArrayList<>();
        List<PMGDZCSJEntity> list = service.list(new QueryWrapper<PMGDZCSJEntity>().eq("XMID", projectId).in("YWQJ", period)
                .and(q -> q.eq("TXBZ","N").or().isNull("TXBZ")));
        if(CollectionUtils.isNotEmpty(list)){
            listRes = BeanMapper.mapList(list, PMGDZCSJVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",listRes);
    }


    @RequestMapping(value = "/refPmgdzcsjData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PMGDZCSJVO>> refOutStoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        String projectId="";
        String period="";
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            projectId =  _con.get("projectId").toString();
            period = _con.get("period").toString();
        }
        Page<PMGDZCSJVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PMGDZCSJVO> list = service.queryByProject(page,wrapper,projectId,period);
//        IPage<PMGDZCSJEntity> page = service.queryPage(param,false);
        IPage<PMGDZCSJVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

}
