package com.ejianc.business.financeintegration.PMPayApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMGDZCSJEntity;
import com.ejianc.business.financeintegration.PMPayApply.mapper.PMGDZCSJMapper;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMGDZCSJService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMGDZCSJVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 *
 *
 * @author sunyj
 */
@Service("PMGDZCSJService")
public class PMGDZCSJServiceImpl extends BaseServiceImpl<PMGDZCSJMapper, PMGDZCSJEntity> implements IPMGDZCSJService {

    @Override
    public List<PMGDZCSJVO> queryByProject(Page pages, QueryWrapper queryWrapper, String projectId,String period) {
        List<PMGDZCSJVO> list = baseMapper.quueryByProject(pages, queryWrapper,projectId,period);
        return list;
    }

    @Override
    public boolean updateEntity(String projectId, List<String> period,String cwFlag) {
        LambdaUpdateWrapper<PMGDZCSJEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PMGDZCSJEntity::getProjectId,projectId);
        updateWrapper.in(PMGDZCSJEntity::getPeriod,period);
        updateWrapper.set(PMGDZCSJEntity::getCwFlag,cwFlag);
        return super.update(updateWrapper);
    }
}
