package com.ejianc.business.financeintegration.PMPayApply.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMPayApplyEntity;
import com.ejianc.business.financeintegration.PMPayApply.mapper.PMPayApplyMapper;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMPayApplyService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * PM支付申请主实体
 *
 * @author generator
 */
@Service("PMPayApplyService")
public class PMPayApplyServiceImpl extends BaseServiceImpl<PMPayApplyMapper, PMPayApplyEntity> implements IPMPayApplyService {

    @Autowired
    private PMPayApplyMapper pmPayApplyMapper;

//    @Autowired
//    private JedisPool jedisPool;

//    private final String OPERATE = "PM_PAY_APPLY_SAVE";

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    // 付款申请生效
    @Override
    public CommonResponse<PMPayApplyVO> takeEffect(PMPayApplyVO paramVO) {
        logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---takeEffect方法--begin，paramVO={}", paramVO);
        // 是否有合同：1有合同、0无合同
        Integer isContract = paramVO.getIsContract();
        // 本次申请金额
        BigDecimal curApplyMny = paramVO.getCurApplyMny();
        // 项目ID
        String projectId = paramVO.getProjectId();
        // 供应商ID
        String supplierId = paramVO.getSupplierId();
        // 合同登记ID
        String contractRegisterId = paramVO.getContractRegisterId();
        // 收款单位ID
        String payeeId = paramVO.getPayeeId();
        // 校验是否有合同标识
        CommonResponse<PMPayApplyVO> isRightContractIdRes = isRightContractRegisterId(paramVO, isContract, contractRegisterId);
        if (isRightContractIdRes != null) {
            return isRightContractIdRes;
        }
        if (curApplyMny == null) {
            logger.error("本次申请金额不能为空，推送财务中间库失败，paramVO-{}", paramVO.toString());
            return CommonResponse.error("本次申请金额不能为空，推送财务中间库失败，请检查数据！");
        }
        // 校验数据维度是否为空
        CommonResponse<PMPayApplyVO> checkRes = isNullDimensions(paramVO);
        if (checkRes != null) {
            return checkRes;
        }

        PMPayApplyEntity saveEntity = new PMPayApplyEntity();
        List<PMPayApplyEntity> alreadyDataList = getByDataDimensions(paramVO);
        if (CollectionUtils.isEmpty(alreadyDataList)) {
            // 不存在，走新增
            // 封装数据维度到saveEntity
            setDimensions(projectId, supplierId, contractRegisterId, payeeId, saveEntity);
            // 累计应付金额 = 本次付款申请
            saveEntity.setTotalPayableMny(curApplyMny);
            // 累计已支付金额 = 0
            saveEntity.setTotalPaidMny(BigDecimal.ZERO);
            // 可支付金额 = 本次付款申请
            saveEntity.setCanPayMny(curApplyMny);
            // 创建时间 = 当前时间
            saveEntity.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            // 主键 = 付款申请ID
            saveEntity.setId(String.valueOf(IdWorker.getId()));
            CommonResponse<PMPayApplyVO> doSaveRes = doSave(saveEntity, "add");
            logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---takeEffect方法--end，结果-{}", JSONObject.toJSONString(doSaveRes, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            return doSaveRes;
        } else if (alreadyDataList.size() > 1) {
            // 查询到的数据超过一条
            logger.error("根据数据维度（项目ID、供应商ID、合同登记ID、收款方ID）查询的数据有误，同一数据维度下只能有一条数据，查询到的数据已超过一条，推送财务中间库失败！查询结果-{}", alreadyDataList.toString());
            return CommonResponse.error("根据数据维度（项目ID、供应商ID、合同登记ID、收款方ID）查询的数据有误，同一数据维度下只能有一条数据，查询到的数据已超过一条，推送财务中间库失败！");
        } else {
            // 已存在，走更新
            PMPayApplyEntity alreadyData = alreadyDataList.get(0);
            // 表中应付
            BigDecimal alreadyDataTotalPayableMny = alreadyData.getTotalPayableMny();
            if (alreadyDataTotalPayableMny == null) {
                alreadyDataTotalPayableMny = BigDecimal.ZERO;
                alreadyData.setTotalPayableMny(BigDecimal.ZERO);
            }
            // 表中已付
            BigDecimal alreadyDataTotalPaidMny = alreadyData.getTotalPaidMny();
            if (alreadyDataTotalPaidMny == null) {
                alreadyDataTotalPaidMny = BigDecimal.ZERO;
                alreadyData.setTotalPaidMny(BigDecimal.ZERO);
            }
            // 表中可支付
            BigDecimal alreadyDataCanPayMny = alreadyData.getCanPayMny();
            if (alreadyDataCanPayMny == null) {
                alreadyDataCanPayMny = BigDecimal.ZERO;
                alreadyData.setCanPayMny(BigDecimal.ZERO);
            }
            // 先校验查询到的数据：累计应付-累计已付>=可支付，如不成立则返回失败
            BigDecimal subtract = alreadyDataTotalPayableMny.subtract(alreadyDataTotalPaidMny);
            if (subtract.compareTo(alreadyDataCanPayMny) < 0) {
                logger.error("查询到的数据中，累计应付金额【" + alreadyDataTotalPayableMny + "】 - 累计已付金额【" + alreadyDataTotalPaidMny + "】 < 可支付金额【" + alreadyDataCanPayMny + "】，推送财务中间库失败，paramVO-{}，查询结果-{}", paramVO.toString(), alreadyDataList.toString());
                return CommonResponse.error("查询到的数据中，累计应付金额【" + alreadyDataTotalPayableMny + "】 - 累计已付金额【" + alreadyDataTotalPaidMny + "】 < 可支付金额【" + alreadyDataCanPayMny + "】，推送财务中间库失败，请检查数据！");
            }
            // 累计应付金额 = 表中累计应付 + 参数中本次付款申请
            saveEntity.setTotalPayableMny(alreadyDataTotalPayableMny.add(curApplyMny));
            // 可支付金额 = 表中可支付 + 参数中本次付款申请
            saveEntity.setCanPayMny(alreadyDataCanPayMny.add(curApplyMny));
            // 修改时间 = 当前时间
            saveEntity.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            // 封装数据维度到saveEntity，根据数据维度进行更新
            setDimensions(projectId, supplierId, contractRegisterId, payeeId, saveEntity);
            CommonResponse<PMPayApplyVO> doSaveRes = doSave(saveEntity, "update");
            logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---takeEffect方法--end，结果-{}", JSONObject.toJSONString(doSaveRes, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            return doSaveRes;
        }
    }

    // 付款申请弃审/关闭
    @Override
    public CommonResponse<PMPayApplyVO> abandonOrClose(PMPayApplyVO paramVO) {
        logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---abandonOrClose方法--begin，paramVO={}", paramVO);
        // 类型：1-PM付款申请弃审、2-PM付款申请关闭
        Integer type = paramVO.getType();
        // 是否有合同：1有合同、0无合同
        Integer isContract = paramVO.getIsContract();
        // 项目ID
        String projectId = paramVO.getProjectId();
        // 供应商ID
        String supplierId = paramVO.getSupplierId();
        // 合同登记ID
        String contractRegisterId = paramVO.getContractRegisterId();
        // 收款单位ID
        String payeeId = paramVO.getPayeeId();
        // 本次申请金额
        BigDecimal curApplyMny = paramVO.getCurApplyMny();
        // 本次释放金额
        BigDecimal curReleaseMny = paramVO.getCurReleaseMny();
        // 校验是否有合同标识
        CommonResponse<PMPayApplyVO> isRightContractIdRes = isRightContractRegisterId(paramVO, isContract, contractRegisterId);
        if (isRightContractIdRes != null) {
            return isRightContractIdRes;
        }
        if (type == null) {
            logger.error("PM付款申请的类型标识（1-弃审、2-关闭）为空，推送财务中间库失败，paramVO-{}", paramVO.toString());
            return CommonResponse.error("PM付款申请的类型标识（1-弃审、2-关闭）不能为空，推送财务中间库失败！");
        }
        if (type != 1 && type != 2) {
            logger.error("PM付款申请的类型标识（1-弃审、2-关闭）错误，推送财务中间库失败，paramVO-{}", paramVO.toString());
            return CommonResponse.error("PM付款申请的类型标识（1-弃审、2-关闭）错误，推送财务中间库失败！");
        }
        if (type == 1 && curApplyMny == null) {
            logger.error("本次申请金额为空，paramVO-{}", paramVO.toString());
            return CommonResponse.error("本次申请金额为空，推送财务中间库失败，请检查数据！");
        }
        if (type == 2 && curReleaseMny == null) {
            logger.error("本次释放申请金额为空，paramVO-{}", paramVO.toString());
            return CommonResponse.error("本次释放申请金额为空，推送财务中间库失败，请检查数据！");
        }
        // 校验数据维度是否为空
        CommonResponse<PMPayApplyVO> checkRes = isNullDimensions(paramVO);
        if (checkRes != null) {
            return checkRes;
        }

        PMPayApplyEntity saveEntity = new PMPayApplyEntity();
        List<PMPayApplyEntity> alreadyDataList = getByDataDimensions(paramVO);
        if (CollectionUtils.isEmpty(alreadyDataList)) {
            logger.error("根据数据维度（项目ID、供应商ID、合同登记ID、收款单位ID）未查询到数据，推送财务中间库失败，paramVO-{}，查询结果-{}", paramVO.toString(), alreadyDataList.toString());
            return CommonResponse.error("根据数据维度（项目ID、供应商ID、合同登记ID、收款单位ID）未查询到数据，推送财务中间库失败！");
        } else if (alreadyDataList.size() > 1) {
            // 查询到的数据超过一条
            logger.error("根据数据维度（项目ID、供应商ID、合同登记ID、收款方ID）查询的数据有误，同一数据维度下只能有一条数据，查询到的数据已超过一条，推送财务中间库失败！，paramVO-{}，查询结果-{}", paramVO.toString(), alreadyDataList.toString());
            return CommonResponse.error("根据数据维度（项目ID、供应商ID、合同登记ID、收款方ID）查询的数据有误，同一数据维度下只能有一条数据，查询到的数据已超过一条，推送财务中间库失败！");
        } else {
            // 已存在，走更新
            PMPayApplyEntity alreadyData = alreadyDataList.get(0);
            // 表中应付
            BigDecimal alreadyDataTotalPayableMny = alreadyData.getTotalPayableMny();
            if (alreadyDataTotalPayableMny == null) {
                alreadyDataTotalPayableMny = BigDecimal.ZERO;
                alreadyData.setTotalPayableMny(BigDecimal.ZERO);
            }
            // 表中已付
            BigDecimal alreadyDataTotalPaidMny = alreadyData.getTotalPaidMny();
            if (alreadyDataTotalPaidMny == null) {
                alreadyDataTotalPaidMny = BigDecimal.ZERO;
                alreadyData.setTotalPaidMny(BigDecimal.ZERO);
            }
            // 表中可支付
            BigDecimal alreadyDataCanPayMny = alreadyData.getCanPayMny();
            if (alreadyDataCanPayMny == null) {
                alreadyDataCanPayMny = BigDecimal.ZERO;
                alreadyData.setCanPayMny(BigDecimal.ZERO);
            }
            // 先校验查询到的数据：累计应付-累计已付>=可支付，如不成立则返回失败
            BigDecimal subtract = alreadyDataTotalPayableMny.subtract(alreadyDataTotalPaidMny);
            if (subtract.compareTo(alreadyDataCanPayMny) < 0) {
                logger.error("查询到的数据中，累计应付金额【" + alreadyDataTotalPayableMny + "】 - 累计已付金额【" + alreadyDataTotalPaidMny + "】 < 可支付金额【" + alreadyDataCanPayMny + "】，推送财务中间库失败，paramVO-{}，查询结果-{}", paramVO.toString(), alreadyDataList.toString());
                return CommonResponse.error("查询到的数据中，累计应付金额【" + alreadyDataTotalPayableMny + "】 - 累计已付金额【" + alreadyDataTotalPaidMny + "】 < 可支付金额【" + alreadyDataCanPayMny + "】，推送财务中间库失败，请检查数据！");
            }
            // 表中已占用
            BigDecimal alreadyDataPayingMny = alreadyData.getPayingMny();
            BigDecimal decimal = BigDecimal.ZERO;
            // 查到的占用金额为空，则占用金额为0
            if (alreadyDataPayingMny != null) {
                decimal = alreadyDataPayingMny;
            }
            if (type == 1) {// 弃审
                BigDecimal subtractCanPay = alreadyDataCanPayMny.subtract(curApplyMny);
                if (subtractCanPay.compareTo(decimal) < 0) {
                    // 可支付金额-本次付款申请金额 < 占用金额
                    logger.error("可支付金额【" + alreadyDataCanPayMny + "】 - 本次付款申请金额【" + curApplyMny + "】 < 占用金额【" + decimal + "】，不允许弃审，推送财务中间库失败，paramVO-{}", paramVO.toString());
                    return CommonResponse.error("可支付金额【" + alreadyDataCanPayMny + "】 - 本次付款申请金额【" + curApplyMny + "】 < 占用金额【" + decimal + "】，不允许弃审，推送财务中间库失败！");
                } else {
                    // 累计应付=累计应付-本次申请
                    BigDecimal subtractPayable = alreadyDataTotalPayableMny.subtract(curApplyMny);
                    if (subtractPayable.compareTo(BigDecimal.ZERO) < 0) {
                        // 累计应付-本次申请 < 0 --> 数据有问题，返回失败
                        logger.error("累计应付金额【" + alreadyDataTotalPayableMny + "】 - 本次申请金额【" + curApplyMny + "】 < 0，此差值不应小于0，数据有误，推送财务中间库失败，请检查数据，paramVO-{}", paramVO.toString());
                        return CommonResponse.error("累计应付金额【" + alreadyDataTotalPayableMny + "】 - 本次申请金额【" + curApplyMny + "】 < 0，此差值不应小于0，数据有误，推送财务中间库失败，请检查数据！");
                    }
                    saveEntity.setTotalPayableMny(subtractPayable);
                    // 可支付=可支付-本次申请
                    if (subtractCanPay.compareTo(BigDecimal.ZERO) < 0) {
                        // 可支付金额-本次申请 < 0 --> 数据有问题，返回失败
                        logger.error("可支付金额【" + alreadyDataCanPayMny + "】 - 本次申请金额【" + curApplyMny + "】 < 0，此差值不应小于0，数据有误，推送财务中间库失败，请检查数据，paramVO-{}", paramVO.toString());
                        return CommonResponse.error("可支付金额【" + alreadyDataCanPayMny + "】 - 本次申请金额【" + curApplyMny + "】 < 0，此差值不应小于0，数据有误，推送财务中间库失败，请检查数据！");
                    }
                    saveEntity.setCanPayMny(subtractCanPay);
                }
            } else {// 关闭
                BigDecimal subtractRelease = alreadyDataCanPayMny.subtract(curReleaseMny);
                if (subtractRelease.compareTo(decimal) < 0) {
                    // 可支付金额-本次释放申请金额 < 占用金额
                    logger.error("可支付金额【" + alreadyDataCanPayMny + "】 - 本次释放申请金额【" + curReleaseMny + "】 < 占用金额【" + decimal + "】，不允许关闭，推送财务中间库失败，paramVO-{}", paramVO.toString());
                    return CommonResponse.error("可支付金额【" + alreadyDataCanPayMny + "】 - 本次释放申请金额【" + curReleaseMny + "】 < 占用金额【" + decimal + "】，不允许关闭，推送财务中间库失败！");
                } else {
                    // 累计应付=累计应付-本次释放申请金额
                    BigDecimal subtractPayable = alreadyDataTotalPayableMny.subtract(curReleaseMny);
                    if (subtractPayable.compareTo(BigDecimal.ZERO) < 0) {
                        // 累计应付-本次释放申请 < 0 --> 数据有问题，返回失败
                        logger.error("累计应付金额【" + alreadyDataTotalPayableMny + "】 - 本次释放申请金额【" + curReleaseMny + "】 < 0，此差值不应小于0，数据有误，推送财务中间库失败，请检查数据，paramVO-{}", paramVO.toString());
                        return CommonResponse.error("累计应付金额【" + alreadyDataTotalPayableMny + "】 - 本次释放申请金额【" + curReleaseMny + "】 < 0，此差值不应小于0，数据有误，推送财务中间库失败，请检查数据！");
                    }
                    saveEntity.setTotalPayableMny(subtractPayable);
                    // 可支付=可支付-本次释放申请金额
                    if (subtractRelease.compareTo(BigDecimal.ZERO) < 0) {
                        // 可支付金额-本次释放申请 < 0 --> 数据有问题，返回失败
                        logger.error("可支付金额【" + alreadyDataCanPayMny + "】 - 本次释放申请金额【" + curReleaseMny + "】 < 0，此差值不应小于0，数据有误，推送财务中间库失败，请检查数据，paramVO-{}", paramVO.toString());
                        return CommonResponse.error("可支付金额【" + alreadyDataCanPayMny + "】 - 本次释放申请金额【" + curReleaseMny + "】 < 0，此差值不应小于0，数据有误，推送财务中间库失败，请检查数据！");
                    }
                    saveEntity.setCanPayMny(subtractRelease);
                }
            }
            saveEntity.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            // 封装数据维度到saveEntity，根据数据维度进行更新
            setDimensions(projectId, supplierId, contractRegisterId, payeeId, saveEntity);
        }
        CommonResponse<PMPayApplyVO> doSaveRes = doSave(saveEntity, "update");
        logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---abandonOrClose方法--end，结果-{}", JSONObject.toJSONString(doSaveRes, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        return doSaveRes;
    }

    // 付款申请核销
    @Override
    public CommonResponse<PMPayApplyVO> writeOff(PMPayApplyVO paramVO) {
        logger.info("付款申请核销---writeOff方法--begin，paramVO-{}", JSONObject.toJSONString(paramVO));
        // 是否有合同：1有合同、0无合同
        Integer isContract = paramVO.getIsContract();
        // 实际已支付金额
        BigDecimal payMnyActual = paramVO.getPayMnyActual();
        // 项目ID
        String projectId = paramVO.getProjectId();
        // 供应商ID
        String supplierId = paramVO.getSupplierId();
        // 合同登记ID
        String contractRegisterId = paramVO.getContractRegisterId();
        // 收款单位ID
        String payeeId = paramVO.getPayeeId();
        // 校验是否有合同标识
        CommonResponse<PMPayApplyVO> isRightContractIdRes = isRightContractRegisterId(paramVO, isContract, contractRegisterId);
        if (isRightContractIdRes != null) {
            return isRightContractIdRes;
        }
        // 校验数据维度是否为空
        CommonResponse<PMPayApplyVO> checkRes = isNullDimensions(paramVO);
        if (checkRes != null) {
            return checkRes;
        }
        if (payMnyActual == null) {
            logger.error("实际支付金额为空，推送财务中间库失败，paramVO-{}", JSONObject.toJSONString(paramVO));
            return CommonResponse.error("实际支付金额不能为空，推送财务中间库失败！");
        }
        PMPayApplyEntity saveEntity = new PMPayApplyEntity();
        List<PMPayApplyEntity> alreadyDataList = getByDataDimensions(paramVO);
        if (CollectionUtils.isEmpty(alreadyDataList)) {
            logger.error("根据数据维度（项目ID-{}、供应商ID-{}、合同登记ID-{}、收款单位ID-{}）未查询到数据，推送财务中间库失败，paramVO-{}，查询结果-{}",
                    paramVO.getProjectId(), paramVO.getSupplierId(), paramVO.getContractRegisterId(), paramVO.getPayeeId(), JSONObject.toJSONString(paramVO), alreadyDataList.toString());
            return CommonResponse.error("根据数据维度（项目ID、供应商ID、合同登记ID、收款单位ID）未查询到数据，推送财务中间库失败！");
        } else if (alreadyDataList.size() > 1) {
            // 查询到的数据超过一条
            logger.error("根据数据维度（项目ID-{}、供应商ID-{}、合同登记ID-{}、收款方ID-{}）查询的数据有误，同一数据维度下只能有一条数据，查询到的数据已超过一条，推送财务中间库失败！，paramVO-{}，查询结果-{}",
                    paramVO.getProjectId(), paramVO.getSupplierId(), paramVO.getContractRegisterId(), paramVO.getPayeeId(), JSONObject.toJSONString(paramVO), alreadyDataList.toString());
            return CommonResponse.error("根据数据维度（项目ID、供应商ID、合同登记ID、收款方ID）查询的数据有误，同一数据维度下只能有一条数据，查询到的数据已超过一条，推送财务中间库失败！");
        } else {
            // 已存在，走更新
            PMPayApplyEntity alreadyData = alreadyDataList.get(0);
            // 表中应付
            BigDecimal alreadyDataTotalPayableMny = alreadyData.getTotalPayableMny();
            if (alreadyDataTotalPayableMny == null) {
                alreadyDataTotalPayableMny = BigDecimal.ZERO;
                alreadyData.setTotalPayableMny(BigDecimal.ZERO);
            }
            // 表中已付
            BigDecimal alreadyDataTotalPaidMny = alreadyData.getTotalPaidMny();
            if (alreadyDataTotalPaidMny == null) {
                alreadyDataTotalPaidMny = BigDecimal.ZERO;
                alreadyData.setTotalPaidMny(BigDecimal.ZERO);
            }
            // 表中可支付
            BigDecimal alreadyDataCanPayMny = alreadyData.getCanPayMny();
            if (alreadyDataCanPayMny == null) {
                alreadyDataCanPayMny = BigDecimal.ZERO;
                alreadyData.setCanPayMny(BigDecimal.ZERO);
            }
            // 先校验查询到的数据：累计应付-累计已付>=可支付，如不成立则返回失败
            BigDecimal subtract = alreadyDataTotalPayableMny.subtract(alreadyDataTotalPaidMny);
            if (subtract.compareTo(alreadyDataCanPayMny) < 0) {
                logger.error("查询到的数据中，累计应付金额【" + alreadyDataTotalPayableMny + "】 - 累计已付金额【" + alreadyDataTotalPaidMny + "】 < 可支付金额【" + alreadyDataCanPayMny + "】，推送财务中间库失败，paramVO-{}，查询结果-{}", paramVO.toString(), alreadyDataList.toString());
                return CommonResponse.error("查询到的数据中，累计应付金额【" + alreadyDataTotalPayableMny + "】 - 累计已付金额【" + alreadyDataTotalPaidMny + "】 < 可支付金额【" + alreadyDataCanPayMny + "】，推送财务中间库失败，请检查数据！");
            }
            if(alreadyData.getCanPayMny().compareTo(BigDecimal.ZERO) <= 0) {
                logger.error("付款结果-【{}】处理失败，当前数据[database-{}]剩余可支付金额为0, 不在进行数据处理操作！", JSONObject.toJSONString(paramVO), JSONObject.toJSONString(saveEntity));
            }

            logger.info("当前累计实付：{}，本次增加实付金额：{}", alreadyDataTotalPaidMny, payMnyActual);
            saveEntity.setTotalPaidMny(payMnyActual.add(alreadyDataTotalPaidMny));
            logger.info("当前可支付金额： {}, 本次扣除可支付金额：{}", alreadyData.getCanPayMny(), payMnyActual);
            saveEntity.setCanPayMny(alreadyData.getCanPayMny().subtract(payMnyActual));
            saveEntity.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            // 封装数据维度到saveEntity，根据数据维度进行更新
            setDimensions(projectId, supplierId, contractRegisterId, payeeId, saveEntity);
            CommonResponse<PMPayApplyVO> doSaveRes = doSave(saveEntity, "update");
            logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---writeOff方法--end，结果-{}", JSONObject.toJSONString(doSaveRes, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            return doSaveRes;
        }
    }

    // 执行保存  根据flag区分走新增还是编辑  operateFlag：'add'-新增、'update'-编辑
    private CommonResponse<PMPayApplyVO> doSave(PMPayApplyEntity saveEntity, String operateFlag) {
        logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---doSave方法--begin，saveEntity-{}，operateFlag-{}", saveEntity.toString(), operateFlag);
        // Redis锁
//        boolean locked = false;
        // 根据数据维度获取锁，维度：项目ID、供应商ID、合同登记ID、收款单位ID
//        String redisKey = saveEntity.getProjectId() + "::" + saveEntity.getSupplierId() + "::" + saveEntity.getContractRegisterId() + "::" + saveEntity.getPayeeId();
//        logger.info("对保存操作添加Redis锁，redisKey-{}", redisKey);
//        Jedis jedis = jedisPool.getResource();
//        logger.info("从jedisPool获取jedis对象，jedis对象-{}", jedis);
//        try {
//            // 在数据维度层面进行加锁
//            locked = RedisTool.tryLock(jedis, redisKey, OPERATE, 600);
//            if (!locked) {
//                RedisUtil.unLock(jedis, false, redisKey, OPERATE);
//                logger.error("获取锁失败，推送财务中间库失败！saveEntity-{}", saveEntity.toString());
//                return CommonResponse.error("获取锁失败，推送财务中间库失败！");
//            }
            logger.info("执行推送财务中间库开始，推送数据-{}", JSONObject.toJSONString(saveEntity));
            if ("add".equals(operateFlag)) {
                pmPayApplyMapper.insertData(saveEntity);
            } else {
                pmPayApplyMapper.updateData(saveEntity);
            }

            logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---doSave方法--end，推送财务中间库成功！");
            return CommonResponse.success("推送财务中间库成功");
//        } catch (Exception e) {
//            logger.info("zzyj-financeintegration---PMPayApplyServiceImpl---doSave方法--end，推送财务中间库失败, saveEntity-{}", saveEntity.toString(), e);
//            return CommonResponse.error("推送财务中间库失败");
//        } finally {
//            //释放单据锁
//            RedisUtil.unLock(jedis, false, redisKey, OPERATE);
//            logger.info("Redis锁释放成功，redisKey-{}", redisKey);
//        }
    }

    // 根据数据维度（项目ID、供应商ID、合同登记ID、收款方ID）查询数据是否已存在，理论上同一个数据维度下只有一条数据
    private List<PMPayApplyEntity> getByDataDimensions(PMPayApplyVO paramVO) {
        logger.info("根据数据维度（项目ID、供应商ID、合同登记ID、收款方ID）查询是否已有数据，同一数据维度下只能有一条数据，paramVO-{}", paramVO.toString());
        QueryWrapper<PMPayApplyEntity> queryWrapper = new QueryWrapper<PMPayApplyEntity>();
        queryWrapper.eq("XMID", paramVO.getProjectId())// 项目ID
                .eq("GYSID", paramVO.getSupplierId())// 供应商ID
                .eq("HTDJID", paramVO.getContractRegisterId())// 合同登记ID
                .eq("SKF", paramVO.getPayeeId());// 收款方ID
        List<PMPayApplyEntity> resList = pmPayApplyMapper.selectList(queryWrapper);
        logger.info("根据数据维度（项目ID、供应商ID、合同登记ID、收款方ID）查询是否已有数据，同一数据维度下只能有一条数据，查询结果-{}", resList.toString());
        return resList;
    }

    // 校验数据维度是否为空：项目ID、供应商ID、合同登记ID、收款单位ID
    private CommonResponse<PMPayApplyVO> isNullDimensions(PMPayApplyVO paramVO) {
        if (StringUtils.isBlank(paramVO.getProjectId())) {
            logger.error("项目ID为空，推送财务中间库失败，paramVO-{}", paramVO.toString());
            return CommonResponse.error("项目ID不能为空，推送财务中间库失败，请检查数据！");
        }
        if (StringUtils.isBlank(paramVO.getSupplierId())) {
            logger.error("供应商ID为空，推送财务中间库失败，paramVO-{}", paramVO.toString());
            return CommonResponse.error("供应商ID不能为空，推送财务中间库失败，请检查数据！");
        }
        if (StringUtils.isBlank(paramVO.getContractRegisterId())) {
            logger.error("合同登记ID为空，推送财务中间库失败，paramVO-{}", paramVO.toString());
            return CommonResponse.error("合同登记ID不能为空，推送财务中间库失败，请检查数据！");
        }
        if (StringUtils.isBlank(paramVO.getPayeeId())) {
            logger.error("收款单位ID为空，推送财务中间库失败，paramVO-{}", paramVO.toString());
            return CommonResponse.error("收款单位ID不能为空，推送财务中间库失败，请检查数据！");
        }
        return null;
    }

    // 校验是否有合同标识：1-有合同-合同ID为自己的合同ID且不应为'-1'，0-无合同-合同ID为'-1'
    private CommonResponse<PMPayApplyVO> isRightContractRegisterId(PMPayApplyVO paramVO, Integer isContract, String contractRegisterId) {
        if (isContract == null) {
            logger.error("是否有合同标识（1-有合同、0-无合同）为空，推送财务中间库失败，paramVO-{}", paramVO.toString());
            return CommonResponse.error("是否有合同标识（1-有合同、0-无合同）为空，推送财务中间库失败！");
        }
        if (isContract != 0 && isContract != 1) {
            logger.error("是否有合同标识（1-有合同、0-无合同）错误，推送财务中间库失败，paramVO-{}", paramVO.toString());
            return CommonResponse.error("是否有合同标识（1-有合同、0-无合同）错误，推送财务中间库失败！");
        }
        if ((isContract == 1 && "-1".equals(contractRegisterId)) || (isContract == 0 && !"-1".equals(contractRegisterId))) {
            logger.error("是否有合同标识（1-有合同、0-无合同）错误或合同登记ID（有合同为合同登记ID，无合同为-1）错误，推送财务中间库失败，paramVO-{}", paramVO.toString());
            return CommonResponse.error("是否有合同标识（1-有合同、0-无合同）错误或合同登记ID（有合同为合同登记ID，无合同为-1）错误，推送财务中间库失败，请检查数据！");
        }
        return null;
    }

    // 封装数据维度到saveEntity：projectId-项目ID，supplierId-供应商ID，contractRegisterId-合同登记ID，payeeId-收款单位ID
    private void setDimensions(String projectId, String supplierId, String contractRegisterId, String payeeId, PMPayApplyEntity saveEntity) {
        saveEntity.setProjectId(projectId);
        saveEntity.setSupplierId(supplierId);
        saveEntity.setContractRegisterId(contractRegisterId);
        saveEntity.setPayeeId(payeeId);
    }
}
