/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.financeintegration.PMPayApply.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMPayApplyEntity;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMPayApplyService;
import com.ejianc.business.financeintegration.PMPayApply.util.RedisUtil;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@RestController
@RequestMapping
public class PMPayApplyApiController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPMPayApplyService pmPayService;
    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "PM_PAY_APPLY_SAVE";
    private long retryInterval = 60000L;
    private final int maxRetryTime = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/PMPayApply/takeEffect"})
    public CommonResponse<PMPayApplyVO> takeEffect(@RequestBody PMPayApplyVO pmPayApplyVO) {
        CommonResponse<PMPayApplyVO> commonResponse;
        Jedis jedis = null;
        String key = null;
        boolean lock = false;
        try {
            key = this.getLockKey(pmPayApplyVO);
            jedis = this.jedisPool.getResource();
            for (int retryTime = 0; !lock && retryTime <= 10; ++retryTime) {
                if (retryTime > 0) {
                    this.logger.info("\u952e-{}\u7b2c{}\u6b21\u5c1d\u8bd5\u83b7\u53d6redis\u9501, \u7b2c{}\u6beb\u79d2\u540e\u5f00\u59cb\u5c1d\u8bd5", new Object[]{key, retryTime, (long)retryTime * this.retryInterval});
                    Thread.sleep((long)retryTime * this.retryInterval);
                }
                lock = this.getLock(key, jedis);
            }
            commonResponse = this.pmPayService.takeEffect(pmPayApplyVO);
        }
        catch (Exception e) {
            CommonResponse commonResponse2;
            try {
                this.logger.error("\u4ed8\u6b3e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff01pmPayApplyVO-{}", (Object)JSONObject.toJSONString((Object)pmPayApplyVO));
                commonResponse2 = CommonResponse.error((String)"\u4ed8\u6b3e\u7ed3\u679c\u5904\u7406\u5931\u8d25!");
            }
            catch (Throwable throwable) {
                RedisUtil.unLock(jedis, false, key, "PM_PAY_APPLY_SAVE");
                this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
                throw throwable;
            }
            RedisUtil.unLock(jedis, false, key, "PM_PAY_APPLY_SAVE");
            this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
            return commonResponse2;
        }
        RedisUtil.unLock(jedis, false, key, "PM_PAY_APPLY_SAVE");
        this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
        return commonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/PMPayApply/abandonOrClose"})
    public CommonResponse<PMPayApplyVO> abandonOrClose(@RequestBody PMPayApplyVO pmPayApplyVO) {
        CommonResponse<PMPayApplyVO> commonResponse;
        Jedis jedis = null;
        String key = null;
        boolean lock = false;
        try {
            key = this.getLockKey(pmPayApplyVO);
            jedis = this.jedisPool.getResource();
            for (int retryTime = 0; !lock && retryTime <= 10; ++retryTime) {
                if (retryTime > 0) {
                    this.logger.info("\u952e-{}\u7b2c{}\u6b21\u5c1d\u8bd5\u83b7\u53d6redis\u9501, \u7b2c{}\u6beb\u79d2\u540e\u5f00\u59cb\u5c1d\u8bd5", new Object[]{key, retryTime, (long)retryTime * this.retryInterval});
                    Thread.sleep((long)retryTime * this.retryInterval);
                }
                lock = this.getLock(key, jedis);
            }
            commonResponse = this.pmPayService.abandonOrClose(pmPayApplyVO);
        }
        catch (Exception e) {
            CommonResponse commonResponse2;
            try {
                this.logger.error("\u4ed8\u6b3e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff01pmPayApplyVO-{}", (Object)JSONObject.toJSONString((Object)pmPayApplyVO));
                commonResponse2 = CommonResponse.error((String)"\u4ed8\u6b3e\u7ed3\u679c\u5904\u7406\u5931\u8d25!");
            }
            catch (Throwable throwable) {
                RedisUtil.unLock(jedis, false, key, "PM_PAY_APPLY_SAVE");
                this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
                throw throwable;
            }
            RedisUtil.unLock(jedis, false, key, "PM_PAY_APPLY_SAVE");
            this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
            return commonResponse2;
        }
        RedisUtil.unLock(jedis, false, key, "PM_PAY_APPLY_SAVE");
        this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
        return commonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/PMPayApply/writeOff"})
    public CommonResponse<PMPayApplyVO> writeOff(@RequestBody PMPayApplyVO pmPayApplyVO) {
        CommonResponse<PMPayApplyVO> commonResponse;
        Jedis jedis = null;
        String key = null;
        boolean lock = false;
        try {
            key = this.getLockKey(pmPayApplyVO);
            jedis = this.jedisPool.getResource();
            for (int retryTime = 0; !lock && retryTime <= 10; ++retryTime) {
                if (retryTime > 0) {
                    this.logger.info("\u952e-{}\u7b2c{}\u6b21\u5c1d\u8bd5\u83b7\u53d6redis\u9501, \u7b2c{}\u6beb\u79d2\u540e\u5f00\u59cb\u5c1d\u8bd5", new Object[]{key, retryTime, (long)retryTime * this.retryInterval});
                    Thread.sleep((long)retryTime * this.retryInterval);
                }
                lock = this.getLock(key, jedis);
            }
            commonResponse = this.pmPayService.writeOff(pmPayApplyVO);
        }
        catch (Exception e) {
            CommonResponse commonResponse2;
            try {
                this.logger.error("\u4ed8\u6b3e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff01pmPayApplyVO-{}", (Object)JSONObject.toJSONString((Object)pmPayApplyVO));
                commonResponse2 = CommonResponse.error((String)"\u4ed8\u6b3e\u7ed3\u679c\u5904\u7406\u5931\u8d25! ");
            }
            catch (Throwable throwable) {
                RedisUtil.unLock(jedis, false, key, "PM_PAY_APPLY_SAVE");
                this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
                throw throwable;
            }
            RedisUtil.unLock(jedis, false, key, "PM_PAY_APPLY_SAVE");
            this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
            return commonResponse2;
        }
        RedisUtil.unLock(jedis, false, key, "PM_PAY_APPLY_SAVE");
        this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
        return commonResponse;
    }

    private String getLockKey(PMPayApplyVO pmPayApplyVO) {
        this.logger.info("\u5904\u7406\u4ed8\u6b3e\u6570\u636e-{}\u524d\u52a0\u9501", (Object)JSONObject.toJSONString((Object)pmPayApplyVO));
        String redisKey = "PM::" + pmPayApplyVO.getProjectId() + "::" + pmPayApplyVO.getSupplierId() + "::" + pmPayApplyVO.getContractRegisterId() + "::" + pmPayApplyVO.getPayeeId();
        this.logger.info("\u5bf9\u4fdd\u5b58\u64cd\u4f5c\u6dfb\u52a0Redis\u9501\uff0credisKey-{}", (Object)redisKey);
        return redisKey;
    }

    private Boolean getLock(String key, Jedis jedis) {
        this.logger.info("\u4ecejedisPool\u83b7\u53d6jedis\u5bf9\u8c61\uff0cjedis\u5bf9\u8c61-{}", (Object)jedis);
        try {
            return RedisTool.tryLock((Jedis)jedis, (String)key, (String)"PM_PAY_APPLY_SAVE", (int)600);
        }
        catch (Exception e) {
            this.logger.info("\u6839\u636e\u952e-{}\u83b7\u53d6reids\u9501\u5f02\u5e38", (Object)key, (Object)e);
            return false;
        }
    }

    @GetMapping(value={"/api/PMPayApply/getPaymentDetail"})
    public CommonResponse<PMPayApplyVO> getPaymentDetail(@RequestParam Long projectId, @RequestParam Long supplyId, @RequestParam Long contractId, @RequestParam Long payeeId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"XMID", (Object)projectId);
        query.eq((Object)"GYSID", (Object)supplyId);
        query.eq((Object)"HTDJID", (Object)contractId);
        query.eq((Object)"SKF", (Object)payeeId);
        PMPayApplyEntity paymentDetail = (PMPayApplyEntity)this.pmPayService.getOne((Wrapper)query);
        if (null != paymentDetail) {
            return CommonResponse.success((Object)BeanMapper.map((Object)paymentDetail, PMPayApplyVO.class));
        }
        return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u4ed8\u6b3e\u4fe1\u606f\uff01", null);
    }
}

