package com.ejianc.business.financeintegration.PMPayApply.controller.api;

import com.ejianc.business.financeintegration.PMPayApply.service.IPMGDZCSJService;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMJJFService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMGDZCSJUPVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMGDZCSJVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMJJFVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * PM费用间接费
 *
 * @author sunyj
 */
@RestController
@RequestMapping
public class PMGDZCSJApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMGDZCSJService pmgdzcsjService;

    // 更新状态
    @PostMapping(value = "/api/PMgdzcsj/updateFlag")
    public CommonResponse<Boolean> updateFlag(@RequestBody PMGDZCSJUPVO pmgdzcsjvo) {
        return CommonResponse.success(pmgdzcsjService.updateEntity(pmgdzcsjvo.getProjectId(),pmgdzcsjvo.getPeriod(),pmgdzcsjvo.getCwFlag()));
    }

}
