package com.ejianc.business.financeintegration.PMPayApply.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMSalaryPayApplyDetailEntity;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMSalaryPayApplyEntity;
import com.ejianc.business.financeintegration.PMPayApply.mapper.PMSalaryPayApplyDetailMapper;
import com.ejianc.business.financeintegration.PMPayApply.mapper.PMSalaryPayApplyMapper;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMSalaryPayApplyDetailService;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMSalaryPayApplyService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyDetailVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * PM工人工资支付申请服务
 *
 * @author generator
 */
@Service("PMSalaryPayApplyService")
public class PMSalaryPayApplyServiceImpl extends BaseServiceImpl<PMSalaryPayApplyMapper, PMSalaryPayApplyEntity> implements IPMSalaryPayApplyService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private IPMSalaryPayApplyDetailService pmSalaryPayApplyDetailService;

    @Autowired
    private PMSalaryPayApplyMapper pmSalaryPayApplyMapper;

    @Autowired
    private PMSalaryPayApplyDetailMapper pmSalaryPayApplyDetailMapper;

    // 工资支付申请生效
    @Override
    public CommonResponse<PMSalaryPayApplyVO> salaryTakeEffect(PMSalaryPayApplyVO pMSalaryPayApplyVO) {
        logger.info("zzyj-financeintegration---PMSalaryPayApplyServiceImpl---salaryTakeEffect方法--begin，pMSalaryPayApplyVO={}", JSONObject.toJSONString(pMSalaryPayApplyVO));
        SimpleDateFormat  sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        // 校验数据维度是否为空
        CommonResponse<PMSalaryPayApplyVO> checkRes = isNullDimensions(pMSalaryPayApplyVO);
        if (checkRes != null) {
            return checkRes;
        }
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("PMDJBH", new Parameter(QueryParam.EQ, pMSalaryPayApplyVO.getSalaryPayApplyId()));
//        List<PMSalaryPayApplyEntity> resultList = super.queryList(queryParam);
//        PMSalaryPayApplyEntity pmSalaryPayApplyEntity = new PMSalaryPayApplyEntity();
//        if (CollectionUtils.isNotEmpty(resultList)){
//            pmSalaryPayApplyEntity = resultList.get(0);
//        }

//        PMSalaryPayApplyEntity pmSalaryPayApplyEntity = super.selectById(pMSalaryPayApplyVO.getSalaryPayApplyId());

        QueryWrapper<PMSalaryPayApplyEntity> queryWrapper = new QueryWrapper<PMSalaryPayApplyEntity>();
        queryWrapper.eq("PMDJBH", pMSalaryPayApplyVO.getSalaryPayApplyId());
        List<PMSalaryPayApplyEntity> resultList = pmSalaryPayApplyMapper.selectList(queryWrapper);
        PMSalaryPayApplyEntity pmSalaryPayApplyEntity = null;
        if (CollectionUtils.isNotEmpty(resultList)){
            pmSalaryPayApplyEntity = resultList.get(0);
        }

        if (null != pmSalaryPayApplyEntity){
            logger.info("根据数据维度-工资支付申请id,查询中间库已有数据，请勿重复提交，查询结果-{}", pmSalaryPayApplyEntity.toString());
            return CommonResponse.error("根据数据维度-工资支付申请id,查询中间库已有数据，请勿重复提交！");
        }

        pMSalaryPayApplyVO.setCreateTime(sdf.format(new Date()));
        PMSalaryPayApplyEntity saveEntity = BeanMapper.map(pMSalaryPayApplyVO, PMSalaryPayApplyEntity.class);
        super.saveOrUpdate(saveEntity);
        pmSalaryPayApplyDetailService.saveOrUpdateBatch(saveEntity.getDetailList(), saveEntity.getDetailList().size());
        logger.info("zzyj-financeintegration---PMSalaryPayApplyServiceImpl--salaryTakeEffect方法--end，推送财务中间库成功！");
        return CommonResponse.success("推送财务中间库成功");
    }

    // 工资支付申请弃审/关闭
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<PMSalaryPayApplyVO> salaryAbandonOrClose(PMSalaryPayApplyVO pMSalaryPayApplyVO) {
        logger.info("zzyj-financeintegration---PMSalaryPayApplyServiceImpl---salaryAbandonOrClose方法--begin，pMSalaryPayApplyVO={}", pMSalaryPayApplyVO);

        if (StringUtils.isBlank(pMSalaryPayApplyVO.getSalaryPayApplyId())){
            logger.error("本次工资支付申请id不能为空，查询中间库工资支付申请数据失败，pMSalaryPayApplyVO-{}", pMSalaryPayApplyVO.toString());
            return CommonResponse.error("本次工资支付申请id不能为空，查询中间库工资支付申请数据失败，请检查数据！");
        }

        PMSalaryPayApplyEntity pmSalaryPayApplyEntity = super.selectById(pMSalaryPayApplyVO.getSalaryPayApplyId());

        //查询子表数据
        QueryWrapper<PMSalaryPayApplyDetailEntity> queryWrapper = new QueryWrapper<PMSalaryPayApplyDetailEntity>();
        queryWrapper.eq("PMDJBH", pMSalaryPayApplyVO.getSalaryPayApplyId());
        List<PMSalaryPayApplyDetailEntity> pmSalaryPayApplyDetailEntityList = pmSalaryPayApplyDetailMapper.selectList(queryWrapper);
        pmSalaryPayApplyEntity.setDetailList(pmSalaryPayApplyDetailEntityList);

        if (null == pmSalaryPayApplyEntity){
            logger.info("根据数据维度-工资支付申请id，查询中间库没有该工资支付申请数据，请检查salaryPayApplyId是否正确，salaryPayApplyId-{}", pMSalaryPayApplyVO.getSalaryPayApplyId());
            return CommonResponse.error("根据数据维度-工资支付申请id，查询中间库没有该工资支付申请数据，请检查salaryPayApplyId是否正确！");
        }
        if ("Y".equals(pmSalaryPayApplyEntity.getQuoteFlag())){
            logger.info("根据数据维度-工资支付申请id，查询中间库该工资支付申请单已被占用，不可撤回，查询结果-{}", pmSalaryPayApplyEntity.toString());
            return CommonResponse.success("根据数据维度-工资支付申请id，查询中间库该工资支付申请单已被占用，不可撤回！", BeanMapper.map(pmSalaryPayApplyEntity, PMSalaryPayApplyVO.class));
        }
        //删除主表
        super.removeById(pmSalaryPayApplyEntity.getSalaryPayApplyId());
        //删除子表
        QueryWrapper<PMSalaryPayApplyDetailEntity> queryDelWrapper = new QueryWrapper<PMSalaryPayApplyDetailEntity>();
        queryDelWrapper.eq("PMDJBH", pmSalaryPayApplyEntity.getSalaryPayApplyId());
        pmSalaryPayApplyDetailService.remove(queryWrapper);
        logger.info("根据数据维度-工资支付申请id，删除工资支付申请单。");

        logger.info("zzyj-financeintegration---PMSalaryPayApplyServiceImpl--salaryAbandonOrClose方法--end，删除中间库相关数据成功！");
        return CommonResponse.success("删除中间库工资支付数据成功，可以撤回！", BeanMapper.map(pmSalaryPayApplyEntity, PMSalaryPayApplyVO.class));
    }

    // 校验工资支付申请数据
    private CommonResponse<PMSalaryPayApplyVO> isNullDimensions(PMSalaryPayApplyVO pMSalaryPayApplyVO) {
        if (StringUtils.isBlank(pMSalaryPayApplyVO.getSalaryPayApplyId())){
            logger.error("本次工资支付申请id不能为空，推送财务中间库失败，pMSalaryPayApplyVO-{}", pMSalaryPayApplyVO.toString());
            return CommonResponse.error("本次工资支付申请id不能为空，推送财务中间库失败，请检查数据！");
        }

        List<PMSalaryPayApplyDetailVO> salaryPayApplyDetailVOList = pMSalaryPayApplyVO.getDetailList();
        if (CollectionUtils.isEmpty(salaryPayApplyDetailVOList)){
            logger.error("本次工资支付申请子表数据不能为空，推送财务中间库失败，pMSalaryPayApplyVO-{}", pMSalaryPayApplyVO.toString());
            return CommonResponse.error("本次工资支付申请子表数据不能为空，推送财务中间库失败，请检查数据！");
        }else {
            for (PMSalaryPayApplyDetailVO detailVO : salaryPayApplyDetailVOList) {
                //id、salaryPayApplyId、姓名、身份证号、账号、金额不能为空
                if (StringUtils.isBlank(detailVO.getId())){
                    logger.error("本次工资支付申请子表数据-id不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("本次工资支付申请子表数据-id不能为空，推送财务中间库失败，请检查数据！");
                }
                if (StringUtils.isBlank(detailVO.getSalaryPayApplyId())){
                    logger.error("本次工资支付申请子表数据-主表id-salaryPayApplyId不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("本次工资支付申请子表数据--主表id-salaryPayApplyId不能为空，推送财务中间库失败，请检查数据！");
                }
                if (StringUtils.isBlank(detailVO.getWorkerName())){
                    logger.error("本次工资支付申请子表数据-工人姓名workerName不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("本次工资支付申请子表数据-工人姓名workerName不能为空，推送财务中间库失败，请检查数据！");
                }
                if (StringUtils.isBlank(detailVO.getWorkerIdCard())){
                    logger.error("本次工资支付申请子表数据-工人身份证号不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("本次工资支付申请子表数据-工人身份证号不能为空，推送财务中间库失败，请检查数据！");
                }
                if (StringUtils.isBlank(detailVO.getWorkerAccountNum())){
                    logger.error("本次工资支付申请子表数据-工人账号workerAccountNum不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("本次工资支付申请子表数据-工人账号workerAccountNum不能为空，推送财务中间库失败，请检查数据！");
                }
                if (null == detailVO.getWorkerApplyTaxMny()){
                    logger.error("本次工资支付申请子表数据-申请金额workerApplyTaxMny不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("本次工资支付申请子表数据-申请金额workerApplyTaxMny不能为空，推送财务中间库失败，请检查数据！");
                }
            }
        }
        return null;
    }

    //消息队列发消息
    @Override
    public void sendUpdateMessage(List<PMSalaryPayApplyDetailVO> pMSalaryPayApplyDetailVOList) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(pMSalaryPayApplyDetailVOList);
        logger.info("接收一建财务系统的工资支付付款信息：{}", JSONObject.toJSONString(pMSalaryPayApplyDetailVOList));
        rabbitTemplate.convertAndSend(new PMSalaryPayApplyDetailVO().SALARY_PAY_RESULT_MESSAGE, mqMessage);
    }

    @Override
    public CommonResponse<String> salaryPayApplyTimingTask() {
        /*
            根据子表“修改时间”，获取本期间发生变化的中间表数据，根据中间表子表“ID”（PM子表ID），更新【工人工资支付申请】或【工人工资支付申请调整单】子表对应的“支付结果”字段
         */
        logger.info("zzyj-financeintegration---PMSalaryPayApplyServiceImpl--salaryPayApplyTimingTask定时任务--begin！");


        String yesterday = cn.hutool.core.date.DateUtil.format(DateUtil.subDays(new Date(), 1), "YYYY/MM/dd HH:mm:ss");
        List<PMSalaryPayApplyDetailEntity> salaryPayApplyDetailEntityList = pmSalaryPayApplyDetailMapper.selectUpdateData(yesterday);
        logger.info("查出需要更新支付状态的数据：{}", JSONObject.toJSONString(salaryPayApplyDetailEntityList));
        List<PMSalaryPayApplyDetailVO> pmSalaryPayApplyDetailVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailEntityList)){
            pmSalaryPayApplyDetailVOList = BeanMapper.mapList(salaryPayApplyDetailEntityList, PMSalaryPayApplyDetailVO.class);
        }
        sendUpdateMessage(pmSalaryPayApplyDetailVOList);
        logger.info("zzyj-financeintegration---PMSalaryPayApplyServiceImpl--salaryPayApplyTimingTask定时任务--end！");
        return CommonResponse.success("定时任务调用成功！");
    }

    public static void main(String[] args) {
        String yesterday = cn.hutool.core.date.DateUtil.format(DateUtil.subDays(new Date(), 1), "YYYY/MM/dd HH:mm:ss");
        System.out.println(yesterday);
    }
}
