package com.ejianc.business.financeintegration.PMReceiptRegister.bean;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import java.math.BigDecimal;

@TableName("PMSKSJ")
public class PMSKSJEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 收款单号
     */
    @TableField(value = "SKDH")
    private String billCode;

    /**
     * 项目ID
     */
    @TableField(value = "XMID")
    private String projectId;

    /**
     * 合同ID
     */
    @TableField(value = "HTID")
    private String contractId;

    /**
     * 金额
     */
    @TableField(value = "JE")
    private BigDecimal sumReceivedMny;

    /**
     * 创建时间
     */
    @TableField(value = "CJSJ")
    private String createTime;

    /**
     * 修改时间
     */
    @TableField(value = "XGSJ",
            fill = FieldFill.INSERT)
    private String updateTime;

    /**
     * 是否PM引用
     */
    @TableField(value = "PMYY")
    private String cwFlag;

    @TableField(value = "SKRQ")
    private String receiptDate;

    /**
     * 备注
     */
    @TableField(value = "BZ")
    private String memo;

    public PMSKSJEntity() {
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public BigDecimal getSumReceivedMny() {
        return sumReceivedMny;
    }

    public void setSumReceivedMny(BigDecimal sumReceivedMny) {
        this.sumReceivedMny = sumReceivedMny;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getCwFlag() {
        return cwFlag;
    }

    public void setCwFlag(String cwFlag) {
        this.cwFlag = cwFlag;
    }

    public String getReceiptDate() {
        return receiptDate;
    }

    public void setReceiptDate(String receiptDate) {
        this.receiptDate = receiptDate;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    @Override
    public String toString() {
        return "PMSKSJEntity{" +
                "billCode='" + billCode + '\'' +
                ", projectId='" + projectId + '\'' +
                ", contractId='" + contractId + '\'' +
                ", sumReceivedMny=" + sumReceivedMny +
                ", createTime='" + createTime + '\'' +
                ", updateTime='" + updateTime + '\'' +
                ", cwFlag='" + cwFlag + '\'' +
                ", receiptDate='" + receiptDate + '\'' +
                ", memo='" + memo + '\'' +
                '}';
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
