package com.ejianc.business.financeintegration.PMSalary.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMSalaryPayApplyService;
import com.ejianc.business.financeintegration.PMPayApply.util.RedisUtil;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyVO;
import com.ejianc.business.financeintegration.PMSalary.bean.PMGzDetailEntity;
import com.ejianc.business.financeintegration.PMSalary.bean.PMGzEntity;
import com.ejianc.business.financeintegration.PMSalary.bean.PMSbgjjgsEntity;
import com.ejianc.business.financeintegration.PMSalary.service.IPMSalarySystemDetailService;
import com.ejianc.business.financeintegration.PMSalary.service.IPMSalarySystemSBService;
import com.ejianc.business.financeintegration.PMSalary.service.IPMSalarySystemService;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 薪资系统
 *
 * @author generator
 */
@RestController
@RequestMapping("/api/PMSalarySystemApply/")
public class PMSalarySystemApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMSalarySystemService pmSalaryPayService;
    @Autowired
    private IPMSalarySystemSBService sbgjjService;
    @Autowired
    private IPMSalarySystemDetailService systemDetailService;
    @Autowired
    private JedisPool jedisPool;

    private final String OPERATE = "PM_SALARY_SYSTEM_SAVE";

    private long retryInterval = 60000;

    private final int maxRetryTime = 10;

    // 工人工资单支付申请生效
    @PostMapping(value = "salaryTakeEffect")
    public CommonResponse<PMGzVO> salaryTakeEffect(@RequestBody List<PMGzVO> vo) {
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        if (CollectionUtils.isNotEmpty(vo)) {

                try {
                    key = getLockKey(vo.get(0).getId());
                    jedis = jedisPool.getResource();
                    while (!lock && retryTime <= maxRetryTime) {
                        if (retryTime > 0) {
                            logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                            Thread.sleep(retryTime * retryInterval);
                        }
                        retryTime++;
                        lock = getLock(key, jedis);
                    }
                    for (PMGzVO salaryPayApplyVO : vo) {
                        CommonResponse<PMGzVO> pmGzVOCommonResponse = pmSalaryPayService.salaryTakeEffect(salaryPayApplyVO);
                        if (pmGzVOCommonResponse.getCode() != 0){
                            return pmGzVOCommonResponse;
                        }
                    }
                    return CommonResponse.success("推送财务中间库成功");
                } catch (Exception e) {
                    logger.error("付款结果处理失败！pmSalaryPayApplyVO-{}", JSONObject.toJSONString(vo.get(0)), e);
                    return CommonResponse.error("付款结果处理失败!");
                } finally {
                    //释放单据锁
                    RedisUtil.unLock(jedis, false, key, OPERATE);
                    logger.info("redisKey-{}进行Redis锁释放", key);
            }
        }else {
            return CommonResponse.error("付款数据传输失败!");
        }
    }


    // 工资支付申请弃审/关闭
    @PostMapping(value = "salaryAbandonOrClose")
    public CommonResponse<PMGzVO> salaryAbandonOrClose(@RequestBody PMGzVO salaryPayApplyVO){
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        try {
            key = getLockKey(salaryPayApplyVO.getId());
            jedis = jedisPool.getResource();
            while(!lock && retryTime <= maxRetryTime) {
                if(retryTime >0 ){
                    logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                    Thread.sleep(retryTime * retryInterval);
                }
                retryTime++;
                lock = getLock(key, jedis);
            }

            return pmSalaryPayService.salaryAbandonOrClose(salaryPayApplyVO);
        } catch (Exception e) {
            logger.error("付款结果处理失败！pmSalaryPayApplyVO-{}", JSONObject.toJSONString(salaryPayApplyVO));
            return CommonResponse.error("付款结果处理失败!");
        } finally {
            //释放单据锁
            RedisUtil.unLock(jedis, false, key, OPERATE);
            logger.info("redisKey-{}进行Redis锁释放", key);
        }
    }

    // 工资支付申请定时任务
    @PostMapping(value = "salaryTimingTask")
    public CommonResponse<String> salaryTimingTask(){
        return pmSalaryPayService.salaryPayApplyTimingTask();
    }



    private String getLockKey(String id) {
        logger.info("处理薪资系统数据-{}前加锁", id);
        // 根据数据维度获取锁，维度：工人工资支付申请单id
        String redisKey = "PM::"+id;
        logger.info("对保存操作添加Redis锁，redisKey-{}", redisKey);
        return redisKey;
    }

    private Boolean getLock(String key, Jedis jedis) {
        logger.info("从jedisPool获取jedis对象，jedis对象-{}", jedis);
        try {
            // 在数据维度层面进行加锁
            return RedisTool.tryLock(jedis, key, OPERATE, 600);
        } catch (Exception e) {
            logger.info("根据键-{}获取reids锁异常", key, e);
            return false;
        }
    }



    // 社保公积金生效
    @PostMapping(value = "sbTakeEffect")
    CommonResponse<PMSbgjjgsVO> sbTakeEffect(@RequestBody List<PMSbgjjgsVO> vo){
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        if (CollectionUtils.isNotEmpty(vo)) {

            try {
                key = getLockKey(vo.get(0).getId());
                jedis = jedisPool.getResource();
                while (!lock && retryTime <= maxRetryTime) {
                    if (retryTime > 0) {
                        logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                        Thread.sleep(retryTime * retryInterval);
                    }
                    retryTime++;
                    lock = getLock(key, jedis);
                }
                for (PMSbgjjgsVO salaryPayApplyVO : vo) {
                    CommonResponse<PMSbgjjgsVO> pmGzVOCommonResponse = pmSalaryPayService.sbTakeEffect(salaryPayApplyVO);
                    if (pmGzVOCommonResponse.getCode() != 0){
                        return pmGzVOCommonResponse;
                    }
                }
                return CommonResponse.success("推送财务中间库成功");
            } catch (Exception e) {
                logger.error("付款结果处理失败！pmSalaryPayApplyVO-{}", JSONObject.toJSONString(vo.get(0)), e);
                return CommonResponse.error("付款结果处理失败!");
            } finally {
                //释放单据锁
                RedisUtil.unLock(jedis, false, key, OPERATE);
                logger.info("redisKey-{}进行Redis锁释放", key);
            }
        }else {
            return CommonResponse.error("付款数据传输失败!");
        }
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("acName");
        fuzzyFields.add("acCode");
        Page<PMSbgjjgsEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<PMSbgjjgsVO> pageList = sbgjjService.queryPageList(page, wrapper);
        IPage<PMSbgjjgsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        //pageData.setRecords(pageList);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", pageList);
        jsonObject.put("total", pageData.getTotal());
        jsonObject.put("current", pageData.getCurrent());
        jsonObject.put("size", pageData.getSize());
        jsonObject.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",jsonObject);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGZList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryGZList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("acName");
        fuzzyFields.add("acCode");
        Page<PMGzEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<PMGzDetailVO> pageList = sbgjjService.queryGzPageList(page, wrapper);
        IPage<PMGzDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(pageList);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", pageList);
        jsonObject.put("total", pageData.getTotal());
        jsonObject.put("current", pageData.getCurrent());
        jsonObject.put("size", pageData.getSize());
        jsonObject.put("pages", pageData.getPages());

        return CommonResponse.success("查询列表数据成功！",jsonObject);
    }


    // 查询工资明细
    @PostMapping(value = "/api/PMSalarySystemApply/querySalaryDetailList")
    CommonResponse<JSONObject> querySalaryDetailList(@RequestBody QueryParam param){
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("id");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("bankName");
        fuzzyFields.add("bankCount");
        fuzzyFields.add("bankAddress");
        fuzzyFields.add("pmBillId");
        Page<PMGzEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<PMGzDetailEntity> pageList = systemDetailService.queryList(param);
        IPage<PMGzDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", pageList);
        jsonObject.put("total", pageData.getTotal());
        jsonObject.put("current", pageData.getCurrent());
        jsonObject.put("size", pageData.getSize());
        jsonObject.put("pages", pageData.getPages());

        return CommonResponse.success("查询工资明细列表数据成功！",jsonObject);
    }
}
