package com.ejianc.business.financeintegration.PMReceiptRegister.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.financeintegration.PMReceiptRegister.bean.PMMnyInfoEntity;
import com.ejianc.business.financeintegration.PMReceiptRegister.bean.PMSKSJEntity;
import com.ejianc.business.financeintegration.PMReceiptRegister.mapper.PMMnyInfoMapper;
import com.ejianc.business.financeintegration.PMReceiptRegister.service.IPMSKSJService;
import com.ejianc.business.financeintegration.PMReceiptRegister.vo.PMMnyInfoVO;
import com.ejianc.business.financeintegration.PMReceiptRegister.vo.PMSKSJVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * PM收款登记
 *
 */
@RestController
@RequestMapping
public class PMMnyInfoApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private PMMnyInfoMapper mapper;


    @PostMapping(value = "/api/PMMnyInfo/insertList")
    public CommonResponse<String> queryList(@RequestBody List<PMMnyInfoVO> list){
        logger.info("新增业财数据开始！");
        List<PMMnyInfoEntity> pmMnyInfoEntities = BeanMapper.mapList(list, PMMnyInfoEntity.class);
        for (PMMnyInfoEntity pmMnyInfoEntity : pmMnyInfoEntities) {
            mapper.insert(pmMnyInfoEntity);
        }
        return CommonResponse.success("查询详情数据成功！");
    }

    // 更新状态
    @PostMapping(value = "/api/PMMnyInfo/updateList")
    public CommonResponse<String> updateList(@RequestBody List<PMMnyInfoVO> list){
        logger.info("新增业财修改开始！");
        List<PMMnyInfoEntity> pmMnyInfoEntities = BeanMapper.mapList(list, PMMnyInfoEntity.class);
        for (PMMnyInfoEntity pmMnyInfoEntity : pmMnyInfoEntities) {
            mapper.updateById(pmMnyInfoEntity);
        }
        return CommonResponse.success("查询详情数据成功！");
    }

}
