package com.ejianc.business.financeintegration.PMReceiptRegister.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.financeintegration.PMReceiptRegister.bean.PMSKSJEntity;
import com.ejianc.business.financeintegration.PMReceiptRegister.mapper.PMSKSJMapper;
import com.ejianc.business.financeintegration.PMReceiptRegister.service.IPMSKSJService;
import com.ejianc.business.financeintegration.PMReceiptRegister.vo.PMSKSJVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * PM收款登记
 *
 */
@Service("PMSKSJService")
public class PMSKSJServiceImpl extends BaseServiceImpl<PMSKSJMapper, PMSKSJEntity> implements IPMSKSJService {

    @Override
    public boolean updateEntity(PMSKSJVO vo) {
        LambdaUpdateWrapper<PMSKSJEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PMSKSJEntity::getProjectId,vo.getProjectIds());
        updateWrapper.in(PMSKSJEntity::getContractId,vo.getContractIds());
        updateWrapper.isNull(PMSKSJEntity::getCwFlag);
        updateWrapper.set(PMSKSJEntity::getCwFlag,vo.getCwFlag());
        updateWrapper.set(PMSKSJEntity::getUpdateTime,vo.getUpdateTime());
        return super.update(updateWrapper);
    }
}
