package com.ejianc.business.financeintegration.PMReceiptRegister.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.financeintegration.PMReceiptRegister.bean.PMSKSJEntity;
import com.ejianc.business.financeintegration.PMReceiptRegister.service.IPMSKSJService;
import com.ejianc.business.financeintegration.PMReceiptRegister.vo.PMSKSJVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * PM收款登记
 *
 */
@RestController
@RequestMapping
public class PMSKSJApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMSKSJService ipmsksjService;


    @PostMapping(value = "/api/PMSksj/queryList")
    public CommonResponse<List<PMSKSJVO>> queryList(){
        List<PMSKSJVO> listRes = new ArrayList<>();
        List<PMSKSJEntity> list = ipmsksjService.list(new QueryWrapper<PMSKSJEntity>().isNull("PMYY"));
        if(CollectionUtils.isNotEmpty(list)){
            listRes = BeanMapper.mapList(list, PMSKSJVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",listRes);
    }

    // 更新状态
    @PostMapping(value = "/api/PMSksj/updateFlag")
    public CommonResponse<Boolean> updateFlag(@RequestBody PMSKSJVO vo) {
        return CommonResponse.success(ipmsksjService.updateEntity(vo));
    }

}
