package com.ejianc.business.financeintegration.PMSalary.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMGDZCSJEntity;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMSalaryPayApplyDetailEntity;
import com.ejianc.business.financeintegration.PMPayApply.bean.PMSalaryPayApplyEntity;
import com.ejianc.business.financeintegration.PMPayApply.mapper.PMSalaryPayApplyDetailMapper;
import com.ejianc.business.financeintegration.PMPayApply.mapper.PMSalaryPayApplyMapper;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMSalaryPayApplyDetailService;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMSalaryPayApplyService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyDetailVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyVO;
import com.ejianc.business.financeintegration.PMSalary.bean.PMGzDetailEntity;
import com.ejianc.business.financeintegration.PMSalary.bean.PMGzEntity;
import com.ejianc.business.financeintegration.PMSalary.bean.PMSbgjjgsEntity;
import com.ejianc.business.financeintegration.PMSalary.mapper.PMSalarySystemDetailMapper;
import com.ejianc.business.financeintegration.PMSalary.mapper.PMSalarySystemMapper;
import com.ejianc.business.financeintegration.PMSalary.mapper.PMSalarySystemSBMapper;
import com.ejianc.business.financeintegration.PMSalary.service.IPMSalarySystemDetailService;
import com.ejianc.business.financeintegration.PMSalary.service.IPMSalarySystemService;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 工资服务
 *
 * @author generator
 */
@Service("PMSalarySystemService")
public class PMSalarySystemServiceImpl extends BaseServiceImpl<PMSalarySystemMapper, PMGzEntity> implements IPMSalarySystemService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private IPMSalarySystemService pmSalarySystemService;

    @Autowired
    private IPMSalarySystemDetailService pmSalarySystemDetailService;

    @Autowired
    private PMSalarySystemMapper pmSalarySystemMapper;

    @Autowired
    private PMSalarySystemDetailMapper pmSalarySystemDetailMapper;

    @Autowired
    private PMSalarySystemSBMapper salarySystemSBMapper;

    // 工资支付申请生效
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<PMGzVO> salaryTakeEffect(PMGzVO pMSalaryPayApplyVO) {
//        logger.info("zzyj-financeintegration---PMSalarySystemServiceImpl---salaryTakeEffect--begin，PMGzVO={}", JSONObject.toJSONString(pMSalaryPayApplyVO));
        SimpleDateFormat  sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        // 校验数据维度是否为空
        CommonResponse<PMGzVO> checkRes = isNullDimensions(pMSalaryPayApplyVO);
        if (checkRes != null) {
            return checkRes;
        }
        QueryWrapper<PMGzEntity> queryWrapper = new QueryWrapper<PMGzEntity>();
        queryWrapper.eq("PMDJID", pMSalaryPayApplyVO.getPmBillId());
        List<PMGzEntity> resultList = pmSalarySystemMapper.selectList(queryWrapper);
        PMGzEntity pmSalaryPayApplyEntity = null;
        if (CollectionUtils.isNotEmpty(resultList)){
            pmSalaryPayApplyEntity = resultList.get(0);
        }

        if (null != pmSalaryPayApplyEntity){
            logger.info("根据数据维度-薪资系统id,查询中间库已有数据，请勿重复提交，查询结果-{}", pmSalaryPayApplyEntity.getAcName()+"!!!"+pmSalaryPayApplyEntity.getPmBillId());
            return CommonResponse.error("根据数据维度-薪资系统id,查询中间库已有数据，请勿重复提交！");
        }

        pMSalaryPayApplyVO.setCreateTime(sdf.format(new Date()));
        PMGzEntity saveEntity = BeanMapper.map(pMSalaryPayApplyVO, PMGzEntity.class);
        super.saveOrUpdate(saveEntity);

        if (CollectionUtils.isNotEmpty(saveEntity.getDetailList())) {
            for (PMGzDetailEntity pmGzDetailEntity : saveEntity.getDetailList()) {
                pmGzDetailEntity.setCreateTime(sdf.format(new Date()));
            }
            pmSalarySystemDetailService.saveOrUpdateBatch(saveEntity.getDetailList(), saveEntity.getDetailList().size());
        }
//        logger.info("zzyj-financeintegration---PMGzEntity--salaryTakeEffect方法--end，推送财务中间库成功！");
        return CommonResponse.success("推送财务中间库成功");
    }

    // 工资支付申请弃审/关闭
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<PMGzVO> salaryAbandonOrClose(PMGzVO pMSalaryPayApplyVO) {
        logger.info("zzyj-financeintegration---PMSalaryPayApplyServiceImpl---salaryAbandonOrClose方法--begin，pMSalaryPayApplyVO={}", pMSalaryPayApplyVO);

        if (StringUtils.isBlank(pMSalaryPayApplyVO.getPmBillId())){
            logger.error("本次工资支付申请id不能为空，查询中间库工资支付申请数据失败，pMSalaryPayApplyVO-{}", pMSalaryPayApplyVO.toString());
            return CommonResponse.error("本次工资支付申请id不能为空，查询中间库工资支付申请数据失败，请检查数据！");
        }


        QueryWrapper<PMGzEntity> queryWrapper = new QueryWrapper<PMGzEntity>();
        queryWrapper.like("PMDJID", pMSalaryPayApplyVO.getPmBillId().substring(0,pMSalaryPayApplyVO.getPmBillId().lastIndexOf("-")));
        queryWrapper.eq("YYBS", "Y");
        List<PMGzEntity> resultList = pmSalarySystemMapper.selectList(queryWrapper);


        //查询子表数据
        QueryWrapper<PMGzDetailEntity> detailQueryWrapper = new QueryWrapper<PMGzDetailEntity>();
        detailQueryWrapper.like("PMDJID", pMSalaryPayApplyVO.getPmBillId().substring(0,pMSalaryPayApplyVO.getPmBillId().lastIndexOf("-")));
        detailQueryWrapper.eq("yybs", "Y");
        List<PMGzDetailEntity> pmSalaryPayApplyDetailEntityList = pmSalarySystemDetailMapper.selectList(detailQueryWrapper);

        if (CollectionUtils.isNotEmpty(resultList)){
            logger.info("本公司本月存在已经引用的信息，个数-{}", resultList.size());
            return CommonResponse.error("本公司本月数据已被引用！");
        }

        if (CollectionUtils.isNotEmpty(pmSalaryPayApplyDetailEntityList)){
            logger.info("本公司本月存在已经引用的人员信息，人数-{}", pmSalaryPayApplyDetailEntityList.size());
            return CommonResponse.error("本公司本月数据已被引用！");
        }

        QueryWrapper<PMSbgjjgsEntity> queryWrappersb = new QueryWrapper<PMSbgjjgsEntity>();
        queryWrappersb.eq("GSID", pMSalaryPayApplyVO.getPmBillId().substring(0,pMSalaryPayApplyVO.getPmBillId().indexOf("-")));
        queryWrappersb.eq("SSNY", pMSalaryPayApplyVO.getPmBillId().substring(pMSalaryPayApplyVO.getPmBillId().indexOf("-")+1,pMSalaryPayApplyVO.getPmBillId().lastIndexOf("-") ));
        queryWrappersb.eq("YYBS", "Y");
        List<PMSbgjjgsEntity> resultListsb = salarySystemSBMapper.selectList(queryWrappersb);
        if (CollectionUtils.isNotEmpty(resultListsb)){
            logger.info("本公司本月社保公积金个税已被引用，个数-{}", resultListsb.size());
            return CommonResponse.error("本公司本月数据已被引用！");
        }

        //删除主表
        QueryWrapper<PMGzEntity> queryDelWrapper = new QueryWrapper<PMGzEntity>();
        queryDelWrapper.like("PMDJID", pMSalaryPayApplyVO.getPmBillId().substring(0,pMSalaryPayApplyVO.getPmBillId().lastIndexOf("-")));
        pmSalarySystemService.remove(queryDelWrapper);

        //删除子表
        QueryWrapper<PMGzDetailEntity> queryDetailDelWrapper = new QueryWrapper<PMGzDetailEntity>();
        queryDetailDelWrapper.like("PMDJID", pMSalaryPayApplyVO.getPmBillId().substring(0,pMSalaryPayApplyVO.getPmBillId().lastIndexOf("-")));
        pmSalarySystemDetailService.remove(queryDetailDelWrapper);


        //删除公积金、社保、个税表
        QueryWrapper<PMSbgjjgsEntity> queryDetailGjjWrapper = new QueryWrapper<PMSbgjjgsEntity>();
        queryDetailGjjWrapper.eq("GSID", pMSalaryPayApplyVO.getPmBillId().substring(0,pMSalaryPayApplyVO.getPmBillId().indexOf("-")));
        queryDetailGjjWrapper.eq("SSNY", pMSalaryPayApplyVO.getPmBillId().substring(pMSalaryPayApplyVO.getPmBillId().indexOf("-")+1,pMSalaryPayApplyVO.getPmBillId().lastIndexOf("-") ));

        salarySystemSBMapper.delete(queryDetailGjjWrapper);

        logger.info("删除薪资系统工资。");

        logger.info("zzyj-financeintegration---薪资--salaryAbandonOrClose方法--end，删除中间库相关数据成功！");

        return CommonResponse.success("删除中间库工资支付数据成功，可以撤回！", pMSalaryPayApplyVO);
    }

    // 校验数据
    private CommonResponse<PMGzVO> isNullDimensions(PMGzVO pMSalaryPayApplyVO) {
        if (StringUtils.isBlank(pMSalaryPayApplyVO.getPmBillId())){
            logger.error("薪资发放单id不能为空，推送财务中间库失败，pMSalaryPayApplyVO-{}", pMSalaryPayApplyVO.toString());
            return CommonResponse.error("薪资发放单id不能为空，推送财务中间库失败，请检查数据！");
        }
        if (StringUtils.isBlank(pMSalaryPayApplyVO.getAcCode()) && StringUtils.isBlank(pMSalaryPayApplyVO.getAcName())){
            logger.error("薪资发放单账套编号不能为空，推送财务中间库失败，pMSalaryPayApplyVO-{}", pMSalaryPayApplyVO.toString());
            return CommonResponse.error("薪资发放单账套编号不能为空，推送财务中间库失败，请检查数据！");
        }
        List<PMGzDetailVO> salaryPayApplyDetailVOList = pMSalaryPayApplyVO.getDetailList();
        if (CollectionUtils.isEmpty(salaryPayApplyDetailVOList)){
//            logger.error("薪资单子表数据不能为空，推送财务中间库失败，pMSalaryPayApplyVO-{}", pMSalaryPayApplyVO.toString());
//            return CommonResponse.error("薪资单子表数据不能为空，推送财务中间库失败，请检查数据！");
        }else {
            for (PMGzDetailVO detailVO : salaryPayApplyDetailVOList) {
                //id、salaryPayApplyId、姓名、身份证号、账号、金额不能为空
                if (StringUtils.isBlank(detailVO.getId())){
                    logger.error("薪资单子表数据-id不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("薪资单子表数据-id不能为空，推送财务中间库失败，请检查数据！");
                }
                if (StringUtils.isBlank(detailVO.getPmBillId())){
                    logger.error("薪资单子表数据-主表id-salaryPayApplyId不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("薪资单子表数据--主表id-salaryPayApplyId不能为空，推送财务中间库失败，请检查数据！");
                }
                if (StringUtils.isBlank(detailVO.getName())){
                    logger.error("本次工资支付申请子表数据-工人姓名workerName不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("本次工资支付申请子表数据-工人姓名workerName不能为空，推送财务中间库失败，请检查数据！");
                }
                if (StringUtils.isBlank(detailVO.getIdCard())){
                    logger.error("薪资单子表数据-工人身份证号不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("薪资单子表数据-工人身份证号不能为空，推送财务中间库失败，请检查数据！");
                }
                if (StringUtils.isBlank(detailVO.getBankCount())){
                    logger.error("薪资单子表数据-工人账号workerAccountNum不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("薪资单子表数据-工人账号workerAccountNum不能为空，推送财务中间库失败，请检查数据！");
                }
                if (null == detailVO.getActualMny()){
                    logger.error("薪资单子表数据-申请金额workerApplyTaxMny不能为空，推送财务中间库失败，detailVO-{}", detailVO.toString());
                    return CommonResponse.error("薪资单子表数据-申请金额workerApplyTaxMny不能为空，推送财务中间库失败，请检查数据！");
                }
            }
        }
        return null;
    }

    //消息队列发消息
    @Override
    public void sendUpdateMessage(List<PMGzDetailVO> pMSalaryPayApplyDetailVOList) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(pMSalaryPayApplyDetailVOList);
        logger.info("接收一建财务系统的薪资支付付款信息：{}", JSONObject.toJSONString(pMSalaryPayApplyDetailVOList));
        rabbitTemplate.convertAndSend(PMGzVO.GZ_PAY_RESULT_MESSAGE, mqMessage);
    }

    @Override
    public CommonResponse<String> salaryPayApplyTimingTask() {
        /*
            根据子表“修改时间”，获取本期间发生变化的中间表数据，根据中间表子表“ID”（PM子表ID），更新【工人工资支付申请】或【工人工资支付申请调整单】子表对应的“支付结果”字段
         */
        logger.info("zzyj-financeintegration---薪资系统--salaryPayApplyTimingTask定时任务--begin！");


        String yesterday = cn.hutool.core.date.DateUtil.format(DateUtil.subDays(new Date(), 1), "YYYY/MM/dd HH:mm:ss");
        List<PMGzDetailEntity> pmGzDetailEntities = pmSalarySystemDetailMapper.selectUpdateData(yesterday);

        logger.info("查出需要更新支付状态的数据：{}", JSONObject.toJSONString(pmGzDetailEntities));
        List<PMGzDetailVO> pmSalaryPayApplyDetailVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(pmGzDetailEntities)){
            pmSalaryPayApplyDetailVOList = BeanMapper.mapList(pmGzDetailEntities, PMGzDetailVO.class);
        }
        sendUpdateMessage(pmSalaryPayApplyDetailVOList);
        logger.info("zzyj-financeintegration---薪资系统--salaryPayApplyTimingTask定时任务--end！");
        return CommonResponse.success("定时任务调用成功！");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<PMSbgjjgsVO> sbTakeEffect(PMSbgjjgsVO pMSalaryPayApplyVO) {
        logger.info("zzyj-financeintegration---PMSalarySystemServiceImpl---sbTakeEffect--begin，PMSbgjjgsVO={}", JSONObject.toJSONString(pMSalaryPayApplyVO));
        SimpleDateFormat  sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        // 校验数据维度是否为空
        CommonResponse<PMSbgjjgsVO> checkRes = isNullDimensionsSb(pMSalaryPayApplyVO);
        if (checkRes != null) {
            return checkRes;
        }
        QueryWrapper<PMSbgjjgsEntity> queryWrapper = new QueryWrapper<PMSbgjjgsEntity>();
        queryWrapper.eq("ZTBH", pMSalaryPayApplyVO.getAcCode());
        queryWrapper.eq("SSNY", pMSalaryPayApplyVO.getYearMonth());
        queryWrapper.eq("TYPE", pMSalaryPayApplyVO.getType());
        List<PMSbgjjgsEntity> resultList = salarySystemSBMapper.selectList(queryWrapper);
        PMSbgjjgsEntity pmSalaryPayApplyEntity = null;
        if (CollectionUtils.isNotEmpty(resultList)){
            pmSalaryPayApplyEntity = resultList.get(0);
        }

        if (null != pmSalaryPayApplyEntity){
            logger.info("根据数据维度-薪资系统id,查询中间库已有数据，请勿重复提交，查询结果-{}", pmSalaryPayApplyEntity.getAcName()+"!!!"+pmSalaryPayApplyEntity.getYearMonth());
            return CommonResponse.error("根据数据维度-薪资系统id,查询中间库已有数据，请勿重复提交！");
        }

        pMSalaryPayApplyVO.setCreateTime(sdf.format(new Date()));
        PMSbgjjgsEntity saveEntity = BeanMapper.map(pMSalaryPayApplyVO, PMSbgjjgsEntity.class);
        salarySystemSBMapper.insert(saveEntity);

        logger.info("zzyj-financeintegration---PMSbgjjgsEntity--sbTakeEffect--end，推送财务中间库成功！");
        return CommonResponse.success("推送财务中间库成功");
    }

    @Override
    public CommonResponse<JSONObject> changeSalaryDetailState(List<String> detailIds) {
        logger.info("直接修改支付状态接口，detailId={}", JSON.toJSONString(detailIds));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String format = sdf.format(new Date());

        LambdaUpdateWrapper<PMGzDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PMGzDetailEntity::getState,"0");
        updateWrapper.eq(PMGzDetailEntity::getYybs,"Y");
        updateWrapper.in(PMGzDetailEntity::getId,detailIds);
        updateWrapper.set(PMGzDetailEntity::getState,"2");
        updateWrapper.set(PMGzDetailEntity::getUpdateTime,format);
        pmSalarySystemDetailService.update(updateWrapper);

//        QueryWrapper<PMGzDetailEntity> queryWrapper = new QueryWrapper<PMGzDetailEntity>();
//        queryWrapper.in("ID", detailIds);
//        queryWrapper.eq("FFZT", "0");
//        queryWrapper.eq("yybs", "Y");
//        List<PMGzDetailEntity> resultList = pmSalarySystemDetailMapper.selectList(queryWrapper);
//
//        logger.info("直接修改支付状态接口，修改时间={}", format);
//        if (CollectionUtils.isNotEmpty(resultList)) {
//            for (PMGzDetailEntity gzDetailEntity : resultList) {
//                gzDetailEntity.setState("2");
//                gzDetailEntity.setUpdateTime(format);
//            }
//
//            pmSalarySystemDetailService.saveOrUpdateBatch(resultList, resultList.size());
//        }
            logger.info("直接修改支付状态成功！");
            return CommonResponse.success("直接修改支付状态成功");
        }


    // 校验数据
    private CommonResponse<PMSbgjjgsVO> isNullDimensionsSb(PMSbgjjgsVO pMSalaryPayApplyVO) {
        if (StringUtils.isBlank(pMSalaryPayApplyVO.getAcCode()) && StringUtils.isBlank(pMSalaryPayApplyVO.getAcName())){
            logger.error("薪资发放单账套编号不能为空，推送财务中间库失败，pMSalaryPayApplyVO-{}", pMSalaryPayApplyVO.toString());
            return CommonResponse.error("薪资发放单账套编号不能为空，推送财务中间库失败，请检查数据！");
        }
        return null;
    }

    public static void main(String[] args) {
        SimpleDateFormat  sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String format = sdf.format(new Date());
        System.out.println(format);

    }
}
