package com.ejianc.business.financeintegration.PMPerformance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.financeintegration.PMPayApply.util.RedisUtil;
import com.ejianc.business.financeintegration.PMPerformance.service.IPMPerformanceService;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceVO;
import com.ejianc.business.financeintegration.PMSalary.bean.PMGzDetailEntity;
import com.ejianc.business.financeintegration.PMSalary.bean.PMGzEntity;
import com.ejianc.business.financeintegration.PMSalary.bean.PMSbgjjgsEntity;
import com.ejianc.business.financeintegration.PMSalary.service.IPMSalarySystemDetailService;
import com.ejianc.business.financeintegration.PMSalary.service.IPMSalarySystemSBService;
import com.ejianc.business.financeintegration.PMSalary.service.IPMSalarySystemService;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.List;
import java.util.Map;

/**
 * 履约保证金
 *
 * @author generator
 */
@RestController
@RequestMapping("/api/PMPerformance/")
public class PMPerformanceApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMPerformanceService performanceService;
    @Autowired
    private JedisPool jedisPool;

    private final String OPERATE = "PM_PERFORMANCE_SAVE";

    private long retryInterval = 60000;

    private final int maxRetryTime = 10;

    // 工人工资单支付申请生效
    @PostMapping(value = "performanceTakeEffect")
    public CommonResponse<PMPerformanceVO> performanceTakeEffect(@RequestBody List<PMPerformanceVO> vo) {
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        if (CollectionUtils.isNotEmpty(vo)) {

                try {
                    key = getLockKey(vo.get(0).getId());
                    jedis = jedisPool.getResource();
                    while (!lock && retryTime <= maxRetryTime) {
                        if (retryTime > 0) {
                            logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                            Thread.sleep(retryTime * retryInterval);
                        }
                        retryTime++;
                        lock = getLock(key, jedis);
                    }

                    if(!lock && retryTime > maxRetryTime) {
                        logger.info("键-{}第{}次尝试获取redis锁失败，已达到最大尝试次数，本次核销失败！", key, retryTime);
                        return CommonResponse.error("薪资结果处理失败!");
                    }

                    for (PMPerformanceVO performanceVO : vo) {
                        CommonResponse<PMPerformanceVO> pmGzVOCommonResponse = performanceService.performanceTakeEffect(performanceVO);
                        logger.info("本次数据解析完成!!!!!!!!!!!!!!!!!!，{}",JSONObject.toJSONString(pmGzVOCommonResponse));
                        if (pmGzVOCommonResponse.getCode() != 0){
                            logger.info("推送财务中间库失败!!!!!!!!!!!!!!!!!!，{}",performanceVO.getPmBillId());
                            return pmGzVOCommonResponse;
                        }
                    }
                    logger.info("推送财务中间库成功!!!!!!!!!!!!!!!!!!");

//                    PMGzVO pmGzVO = new PMGzVO();
                    return CommonResponse.success("推送财务中间库成功", null);
                } catch (Exception e) {
                    logger.error("付款结果处理失败！pmSalaryPayApplyVO-{}", JSONObject.toJSONString(vo.get(0)), e);
                    return CommonResponse.error("付款结果处理失败!");
                } finally {
                    //释放单据锁
                    RedisUtil.unLock(jedis, false, key, OPERATE);
                    logger.info("redisKey-{}进行Redis锁释放", key);
            }
        }else {
            return CommonResponse.error("付款数据传输失败!");
        }
    }


    // 工资支付申请弃审/关闭
    @PostMapping(value = "performanceAbandonOrClose")
    public CommonResponse<PMPerformanceVO> performanceAbandonOrClose(@RequestBody PMPerformanceVO vo){
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        try {
            key = getLockKey(vo.getId());
            jedis = jedisPool.getResource();
            while(!lock && retryTime <= maxRetryTime) {
                if(retryTime >0 ){
                    logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                    Thread.sleep(retryTime * retryInterval);
                }
                retryTime++;
                lock = getLock(key, jedis);
            }

            return performanceService.performanceAbandonOrClose(vo);
        } catch (Exception e) {
            logger.error("付款结果处理失败！pmSalaryPayApplyVO-{}", JSONObject.toJSONString(vo));
            return CommonResponse.error("付款结果处理失败!");
        } finally {
            //释放单据锁
            RedisUtil.unLock(jedis, false, key, OPERATE);
            logger.info("redisKey-{}进行Redis锁释放", key);
        }
    }

    // 工资支付申请定时任务
    @PostMapping(value = "salaryTimingTask")
    public CommonResponse<String> salaryTimingTask(){
        return performanceService.performancePayApplyTimingTask();
    }



    private String getLockKey(String id) {
        logger.info("处理薪资系统数据-{}前加锁", id);
        // 根据数据维度获取锁，维度：工人工资支付申请单id
        String redisKey = "PM::"+id;
        logger.info("对保存操作添加Redis锁，redisKey-{}", redisKey);
        return redisKey;
    }

    private Boolean getLock(String key, Jedis jedis) {
        logger.info("从jedisPool获取jedis对象，jedis对象-{}", jedis);
        try {
            // 在数据维度层面进行加锁
            return RedisTool.tryLock(jedis, key, OPERATE, 600);
        } catch (Exception e) {
            logger.info("根据键-{}获取reids锁异常", key, e);
            return false;
        }
    }



    // 定时任务--获取收款数据
    @PostMapping(value = "getReceiptData")
    public CommonResponse<String> getReceiptData(){
        return performanceService.getRecepitData();
    }

}
