package com.ejianc.business.financeintegration.PMPerformance.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPerformance.bean.PMPerformanceEntity;
import com.ejianc.business.financeintegration.PMPerformance.bean.PMPerformanceReceiptEntity;
import com.ejianc.business.financeintegration.PMPerformance.mapper.PMPerformanceMapper;
import com.ejianc.business.financeintegration.PMPerformance.service.IPMPerformanceService;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceReceiptVO;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 履约保证金
 *
 * @author generator
 */
@Service("PMPerformanceService")
public class PMPerformanceServiceImpl extends BaseServiceImpl<PMPerformanceMapper, PMPerformanceEntity> implements IPMPerformanceService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private PMPerformanceMapper performanceMapper;

    // 推送扣款单
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<PMPerformanceVO> performanceTakeEffect(PMPerformanceVO pMSalaryPayApplyVO) {
        SimpleDateFormat  sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        // 校验数据维度是否为空
        CommonResponse<PMPerformanceVO> checkRes = isNullDimensions(pMSalaryPayApplyVO);
        if (checkRes != null) {
            return checkRes;
        }
        QueryWrapper<PMPerformanceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PMDJID", pMSalaryPayApplyVO.getPmBillId());
        List<PMPerformanceEntity> resultList = performanceMapper.selectList(queryWrapper);
        PMPerformanceEntity pmSalaryPayApplyEntity = null;
        if (CollectionUtils.isNotEmpty(resultList)){
            pmSalaryPayApplyEntity = resultList.get(0);
        }

        if (null != pmSalaryPayApplyEntity){
            logger.info("根据数据维度-扣款单id,查询中间库已有数据，请勿重复提交-{}", pmSalaryPayApplyEntity.getPmBillId());
            return CommonResponse.error("根据数据维度-扣款单id,查询中间库已有数据，请勿重复提交！");
        }

        pMSalaryPayApplyVO.setCreateTime(sdf.format(new Date()));
        PMPerformanceEntity saveEntity = BeanMapper.map(pMSalaryPayApplyVO, PMPerformanceEntity.class);
        super.saveOrUpdate(saveEntity);

        return CommonResponse.success("推送财务中间库成功");
    }

    // 扣款单弃审/关闭
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<PMPerformanceVO> performanceAbandonOrClose(PMPerformanceVO pMSalaryPayApplyVO) {
        logger.info("zzyj-financeintegration---PMSalaryPayApplyServiceImpl---salaryAbandonOrClose方法--begin，pMSalaryPayApplyVO={}", pMSalaryPayApplyVO);

        if (StringUtils.isBlank(pMSalaryPayApplyVO.getPmBillId())){
            logger.error("本次扣款单id不能为空，查询中间库数据失败!!!");
            return CommonResponse.error("本次扣款单id不能为空，查询中间库工资支付申请数据失败，请检查数据！");
        }

        QueryWrapper<PMPerformanceEntity> queryWrapper = new QueryWrapper<PMPerformanceEntity>();
        queryWrapper.like("PMDJID", pMSalaryPayApplyVO.getPmBillId());
        queryWrapper.eq("YYBS", "Y");
        List<PMPerformanceEntity> resultList = performanceMapper.selectList(queryWrapper);

        if (CollectionUtils.isNotEmpty(resultList)){
            logger.info("此单据已被财务系统引用！！");
            return CommonResponse.error("此单据已被财务系统引用！");
        }

        //删除主表
        QueryWrapper<PMPerformanceEntity> queryDelWrapper = new QueryWrapper<PMPerformanceEntity>();
        queryDelWrapper.like("PMDJID", pMSalaryPayApplyVO.getPmBillId());
        super.remove(queryDelWrapper);


        logger.info("zzyj-financeintegration---履约保证金--performanceAbandonOrClose方法--end，删除中间库相关数据成功！");

        return CommonResponse.success("删除中间库履约保证金额扣款数据成功，可以撤回！", pMSalaryPayApplyVO);
    }

    // 校验数据
    private CommonResponse<PMPerformanceVO> isNullDimensions(PMPerformanceVO pMSalaryPayApplyVO) {
        if (StringUtils.isBlank(pMSalaryPayApplyVO.getPmBillId())){
            logger.error("履约保证金扣款单id不能为空，推送财务中间库失败，PMPerformanceVO-{}", pMSalaryPayApplyVO.toString());
            return CommonResponse.error("履约保证金扣款单id不能为空，推送财务中间库失败，请检查数据！");
        }
        if (StringUtils.isBlank(pMSalaryPayApplyVO.getProjectId())){
            logger.error("项目id不能为空，推送财务中间库失败，PMPerformanceVO-{}", pMSalaryPayApplyVO.getProjectId());
            return CommonResponse.error("项目id不能为空，推送财务中间库失败，请检查数据！");
        }
        if (null == pMSalaryPayApplyVO.getActualMny()){
            logger.error("扣款金额不能为空，推送财务中间库失败，getActualMny-{}", pMSalaryPayApplyVO.getActualMny());
            return CommonResponse.error("扣款金额不能为空，推送财务中间库失败，请检查数据！");
        }
        return null;
    }



    @Override
    public CommonResponse<String> performancePayApplyTimingTask() {
        /*
            根据子表“修改时间”，获取本期间发生变化的中间表数据，根据中间表子表“ID”（PM子表ID），更新对应的“支付结果”字段
         */
        logger.info("履约保证金付款数据定时任务--begin！");

        String yesterday = cn.hutool.core.date.DateUtil.format(DateUtil.subDays(new Date(), 1), "yyyy-MM-dd HH:mm:ss");
        List<PMPerformanceEntity> entityList = baseMapper.selectUpdateData(yesterday);
        logger.info("查出需要更新支付状态的数据：{}", JSONObject.toJSONString(entityList));
        List<PMPerformanceVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(entityList)){
            voList = BeanMapper.mapList(entityList, PMPerformanceVO.class);
        }
        sendUpdateMessage(voList);
        logger.info("履约保证金付款数据定时任务--end！");
        return CommonResponse.success("定时任务调用成功！");
    }

    // 定时任务--获取收款数据
    @Override
    public CommonResponse<String> getRecepitData(){
        /*
            根据子表“zyskd_djrq单据日期”，获取本期间发生变化的中间表数据，根据中间表子表“ID”（PM子表ID），更新对应的“支付结果”字段
         */
        logger.info("履约保证金收款数据定时任务--begin！");
        //"yyyy/MM/dd HH:mm:ss"
        String yesterday = cn.hutool.core.date.DateUtil.format(DateUtil.subDays(new Date(), 1), "yyyyMMdd");
        List<PMPerformanceReceiptEntity> entityList = baseMapper.selectReceiptData(yesterday);
        logger.info("查出最新的收款的数据：{}", JSONObject.toJSONString(entityList));
        List<PMPerformanceReceiptVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(entityList)){
            voList = BeanMapper.mapList(entityList, PMPerformanceReceiptVO.class);
        }
        sendReceiptMessage(voList);
        logger.info("履约保证金收款数据定时任务--end！");
        return CommonResponse.success("定时任务调用成功！");
    }

    //消息队列发消息
    @Override
    public void sendUpdateMessage(List<PMPerformanceVO> performanceVOS) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(performanceVOS);
        logger.info("接收一建财务系统的履约保证金扣款信息：{}", JSONObject.toJSONString(performanceVOS));
        rabbitTemplate.convertAndSend(new PMPerformanceVO().PERFORMANCE_RESULT_MESSAGE, mqMessage);
    }
    //消息队列发-收款数据
    @Override
    public void sendReceiptMessage(List<PMPerformanceReceiptVO> performanceVOS) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(performanceVOS);
        logger.info("接收一建财务系统的履约保证金收款数据：{}", JSONObject.toJSONString(performanceVOS));
        rabbitTemplate.convertAndSend(new PMPerformanceReceiptVO().PERFORMANCE_RESULT_MESSAGE, mqMessage);
    }

}
