/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.financeintegration.PMPerformance.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPerformance.bean.PMPerformanceReturnEntity;
import com.ejianc.business.financeintegration.PMPerformance.mapper.PMPerformanceReturnMapper;
import com.ejianc.business.financeintegration.PMPerformance.service.IPMPerformanceReturnService;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceReturnVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="PMPerformanceReturnService")
public class PMPerformanceReturnServiceImpl
extends BaseServiceImpl<PMPerformanceReturnMapper, PMPerformanceReturnEntity>
implements IPMPerformanceReturnService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private PMPerformanceReturnMapper performanceMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<PMPerformanceReturnVO> performanceTakeEffect(PMPerformanceReturnVO pMSalaryPayApplyVO) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CommonResponse<PMPerformanceReturnVO> checkRes = this.isNullDimensions(pMSalaryPayApplyVO);
        if (checkRes != null) {
            return checkRes;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PMDJID", (Object)pMSalaryPayApplyVO.getPmBillId());
        List resultList = this.performanceMapper.selectList((Wrapper)queryWrapper);
        PMPerformanceReturnEntity pmSalaryPayApplyEntity = null;
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            pmSalaryPayApplyEntity = (PMPerformanceReturnEntity)resultList.get(0);
        }
        if (null != pmSalaryPayApplyEntity) {
            this.logger.info("\u6839\u636e\u6570\u636e\u7ef4\u5ea6-\u6263\u6b3e\u5355id,\u67e5\u8be2\u4e2d\u95f4\u5e93\u5df2\u6709\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4-{}", (Object)pmSalaryPayApplyEntity.getPmBillId());
            return CommonResponse.error((String)"\u6839\u636e\u6570\u636e\u7ef4\u5ea6-\u6263\u6b3e\u5355id,\u67e5\u8be2\u4e2d\u95f4\u5e93\u5df2\u6709\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
        }
        pMSalaryPayApplyVO.setCreateTime(sdf.format(new Date()));
        PMPerformanceReturnEntity saveEntity = (PMPerformanceReturnEntity)BeanMapper.map((Object)pMSalaryPayApplyVO, PMPerformanceReturnEntity.class);
        super.saveOrUpdate((Object)saveEntity);
        return CommonResponse.success((String)"\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<PMPerformanceReturnVO> performanceAbandonOrClose(PMPerformanceReturnVO pMSalaryPayApplyVO) {
        this.logger.info("zzyj-financeintegration---PMSalaryPayApplyServiceImpl---salaryAbandonOrClose\u65b9\u6cd5--begin\uff0cpMSalaryPayApplyVO={}", (Object)pMSalaryPayApplyVO);
        if (StringUtils.isBlank((CharSequence)pMSalaryPayApplyVO.getPmBillId())) {
            this.logger.error("\u672c\u6b21\u6263\u6b3e\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u67e5\u8be2\u4e2d\u95f4\u5e93\u6570\u636e\u5931\u8d25!!!");
            return CommonResponse.error((String)"\u672c\u6b21\u6263\u6b3e\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u67e5\u8be2\u4e2d\u95f4\u5e93\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"PMDJID", (Object)pMSalaryPayApplyVO.getPmBillId());
        queryWrapper.eq((Object)"YYBS", (Object)"Y");
        List resultList = this.performanceMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            this.logger.info("\u6b64\u5355\u636e\u5df2\u88ab\u8d22\u52a1\u7cfb\u7edf\u5f15\u7528\uff01\uff01");
            return CommonResponse.error((String)"\u6b64\u5355\u636e\u5df2\u88ab\u8d22\u52a1\u7cfb\u7edf\u5f15\u7528\uff01");
        }
        QueryWrapper queryDelWrapper = new QueryWrapper();
        queryDelWrapper.like((Object)"PMDJID", (Object)pMSalaryPayApplyVO.getPmBillId());
        super.remove((Wrapper)queryDelWrapper);
        this.logger.info("zzyj-financeintegration---\u5c65\u7ea6\u4fdd\u8bc1\u91d1--performanceAbandonOrClose\u65b9\u6cd5--end\uff0c\u5220\u9664\u4e2d\u95f4\u5e93\u76f8\u5173\u6570\u636e\u6210\u529f\uff01");
        return CommonResponse.success((String)"\u5220\u9664\u4e2d\u95f4\u5e93\u5c65\u7ea6\u4fdd\u8bc1\u91d1\u989d\u6263\u6b3e\u6570\u636e\u6210\u529f\uff0c\u53ef\u4ee5\u64a4\u56de\uff01", (Object)pMSalaryPayApplyVO);
    }

    private CommonResponse<PMPerformanceReturnVO> isNullDimensions(PMPerformanceReturnVO pMSalaryPayApplyVO) {
        if (StringUtils.isBlank((CharSequence)pMSalaryPayApplyVO.getPmBillId())) {
            this.logger.error("\u5c65\u7ea6\u4fdd\u8bc1\u91d1\u6263\u6b3e\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cPMPerformanceReturnVO-{}", (Object)pMSalaryPayApplyVO.toString());
            return CommonResponse.error((String)"\u5c65\u7ea6\u4fdd\u8bc1\u91d1\u6263\u6b3e\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)pMSalaryPayApplyVO.getProjectId())) {
            this.logger.error("\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cPMPerformanceReturnVO-{}", (Object)pMSalaryPayApplyVO.getProjectId());
            return CommonResponse.error((String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        if (null == pMSalaryPayApplyVO.getActualMny()) {
            this.logger.error("\u6263\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0cgetActualMny-{}", (Object)pMSalaryPayApplyVO.getActualMny());
            return CommonResponse.error((String)"\u6263\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        return null;
    }

    @Override
    public CommonResponse<String> performancePayApplyTimingTask() {
        this.logger.info("\u5c65\u7ea6\u4fdd\u8bc1\u91d1\u4ed8\u6b3e\u6570\u636e\u5b9a\u65f6\u4efb\u52a1--begin\uff01");
        String yesterday = DateUtil.format((Date)com.ejianc.framework.core.kit.time.DateUtil.subDays((Date)new Date(), (int)1), (String)"yyyy/MM/dd HH:mm:ss");
        List<PMPerformanceReturnEntity> entityList = ((PMPerformanceReturnMapper)this.baseMapper).selectUpdateData(yesterday);
        this.logger.info("\u67e5\u51fa\u9700\u8981\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(entityList));
        List<Object> voList = new ArrayList<PMPerformanceReturnVO>();
        if (CollectionUtils.isNotEmpty(entityList)) {
            voList = BeanMapper.mapList(entityList, PMPerformanceReturnVO.class);
        }
        this.sendUpdateMessage(voList);
        this.logger.info("\u5c65\u7ea6\u4fdd\u8bc1\u91d1\u4ed8\u6b3e\u6570\u636e\u5b9a\u65f6\u4efb\u52a1--end\uff01");
        return CommonResponse.success((String)"\u5b9a\u65f6\u4efb\u52a1\u8c03\u7528\u6210\u529f\uff01");
    }

    @Override
    public void sendUpdateMessage(List<PMPerformanceReturnVO> performanceVOS) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(performanceVOS);
        this.logger.info("\u63a5\u6536\u4e00\u5efa\u8d22\u52a1\u7cfb\u7edf\u7684\u5c65\u7ea6\u4fdd\u8bc1\u91d1\u6263\u6b3e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(performanceVOS));
        new PMPerformanceReturnVO();
        this.rabbitTemplate.convertAndSend("performanceReturnResult", (Object)mqMessage);
    }
}

