package com.ejianc.business.financeintegration.PMPayApply.controller.api;

import com.ejianc.business.financeintegration.PMPayApply.bean.PMJJFEntity;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMJJFService;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMPayApplyService;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMJJFVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.beanutils.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * PM费用间接费
 *
 * @author sunyj
 */
@RestController
@RequestMapping
public class PMJJFApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMJJFService pmjjfService;

    // 更新状态
    @PostMapping(value = "/api/PMJjf/updateFlag")
    public CommonResponse<Boolean> updateFlag(@RequestBody PMJJFVO pmjjfvo) {
        return CommonResponse.success(pmjjfService.updateEntity(pmjjfvo.getProjectId(),pmjjfvo.getPeriod(),pmjjfvo.getCwFlag()));
    }

}
