package com.ejianc.business.financeintegration.PMSalary.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.financeintegration.PMPayApply.service.IPMSalaryPayApplyService;
import com.ejianc.business.financeintegration.PMPayApply.util.RedisUtil;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyVO;
import com.ejianc.business.financeintegration.PMSalary.service.IPMSalarySystemService;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.List;

/**
 * 薪资系统
 *
 * @author generator
 */
@RestController
@RequestMapping("/api/PMSalarySystemApply/")
public class PMSalarySystemApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMSalarySystemService pmSalaryPayService;

    @Autowired
    private JedisPool jedisPool;

    private final String OPERATE = "PM_SALARY_SYSTEM_SAVE";

    private long retryInterval = 60000;

    private final int maxRetryTime = 10;

    // 工人工资单支付申请生效
    @PostMapping(value = "salaryTakeEffect")
    public CommonResponse<PMGzVO> salaryTakeEffect(@RequestBody List<PMGzVO> vo) {
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        if (CollectionUtils.isNotEmpty(vo)) {

                try {
                    key = getLockKey(vo.get(0).getId());
                    jedis = jedisPool.getResource();
                    while (!lock && retryTime <= maxRetryTime) {
                        if (retryTime > 0) {
                            logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                            Thread.sleep(retryTime * retryInterval);
                        }
                        retryTime++;
                        lock = getLock(key, jedis);
                    }
                    for (PMGzVO salaryPayApplyVO : vo) {
                        CommonResponse<PMGzVO> pmGzVOCommonResponse = pmSalaryPayService.salaryTakeEffect(salaryPayApplyVO);
                        if (pmGzVOCommonResponse.getCode() != 0){
                            return pmGzVOCommonResponse;
                        }
                    }
                    return CommonResponse.success("推送财务中间库成功");
                } catch (Exception e) {
                    logger.error("付款结果处理失败！pmSalaryPayApplyVO-{}", JSONObject.toJSONString(vo.get(0)), e);
                    return CommonResponse.error("付款结果处理失败!");
                } finally {
                    //释放单据锁
                    RedisUtil.unLock(jedis, false, key, OPERATE);
                    logger.info("redisKey-{}进行Redis锁释放", key);
            }
        }else {
            return CommonResponse.error("付款数据传输失败!");
        }
    }


    // 工资支付申请弃审/关闭
    @PostMapping(value = "salaryAbandonOrClose")
    public CommonResponse<PMGzVO> salaryAbandonOrClose(@RequestBody PMGzVO salaryPayApplyVO){
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        try {
            key = getLockKey(salaryPayApplyVO.getId());
            jedis = jedisPool.getResource();
            while(!lock && retryTime <= maxRetryTime) {
                if(retryTime >0 ){
                    logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                    Thread.sleep(retryTime * retryInterval);
                }
                retryTime++;
                lock = getLock(key, jedis);
            }

            return pmSalaryPayService.salaryAbandonOrClose(salaryPayApplyVO);
        } catch (Exception e) {
            logger.error("付款结果处理失败！pmSalaryPayApplyVO-{}", JSONObject.toJSONString(salaryPayApplyVO));
            return CommonResponse.error("付款结果处理失败!");
        } finally {
            //释放单据锁
            RedisUtil.unLock(jedis, false, key, OPERATE);
            logger.info("redisKey-{}进行Redis锁释放", key);
        }
    }

    // 工资支付申请定时任务
    @PostMapping(value = "salaryTimingTask")
    public CommonResponse<String> salaryTimingTask(){
        return pmSalaryPayService.salaryPayApplyTimingTask();
    }



    private String getLockKey(String id) {
        logger.info("处理薪资系统数据-{}前加锁", id);
        // 根据数据维度获取锁，维度：工人工资支付申请单id
        String redisKey = "PM::"+id;
        logger.info("对保存操作添加Redis锁，redisKey-{}", redisKey);
        return redisKey;
    }

    private Boolean getLock(String key, Jedis jedis) {
        logger.info("从jedisPool获取jedis对象，jedis对象-{}", jedis);
        try {
            // 在数据维度层面进行加锁
            return RedisTool.tryLock(jedis, key, OPERATE, 600);
        } catch (Exception e) {
            logger.info("根据键-{}获取reids锁异常", key, e);
            return false;
        }
    }



    // 社保公积金生效
    @PostMapping(value = "sbTakeEffect")
    CommonResponse<PMSbgjjgsVO> sbTakeEffect(@RequestBody List<PMSbgjjgsVO> vo){
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        if (CollectionUtils.isNotEmpty(vo)) {

            try {
                key = getLockKey(vo.get(0).getId());
                jedis = jedisPool.getResource();
                while (!lock && retryTime <= maxRetryTime) {
                    if (retryTime > 0) {
                        logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                        Thread.sleep(retryTime * retryInterval);
                    }
                    retryTime++;
                    lock = getLock(key, jedis);
                }
                for (PMSbgjjgsVO salaryPayApplyVO : vo) {
                    CommonResponse<PMSbgjjgsVO> pmGzVOCommonResponse = pmSalaryPayService.sbTakeEffect(salaryPayApplyVO);
                    if (pmGzVOCommonResponse.getCode() != 0){
                        return pmGzVOCommonResponse;
                    }
                }
                return CommonResponse.success("推送财务中间库成功");
            } catch (Exception e) {
                logger.error("付款结果处理失败！pmSalaryPayApplyVO-{}", JSONObject.toJSONString(vo.get(0)), e);
                return CommonResponse.error("付款结果处理失败!");
            } finally {
                //释放单据锁
                RedisUtil.unLock(jedis, false, key, OPERATE);
                logger.info("redisKey-{}进行Redis锁释放", key);
            }
        }else {
            return CommonResponse.error("付款数据传输失败!");
        }
    }

}
