package com.ejianc.business.financeintegration.ZzyjTradePayApply.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPayApply.util.RedisUtil;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.business.financeintegration.ZzyjTradePayApply.bean.ZzyjTradePayApplyEntity;
import com.ejianc.business.financeintegration.ZzyjTradePayApply.service.IZzyjTradePayApplyService;
import com.ejianc.business.financeintegration.ZzyjTradePayApply.vo.ZzyjTradePayApplyVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.List;
import java.util.Map;

/**
 * PM支付申请
 *
 * @author generator
 */
@RestController
@RequestMapping
public class ZzyjTradePayApplyApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IZzyjTradePayApplyService pmPayService;

    @Autowired
    private JedisPool jedisPool;

    private final String OPERATE = "PM_PAY_APPLY_SAVE";

    private long retryInterval = 3000;

    private final int maxRetryTime = 10;

    // 付款申请生效
    @PostMapping(value = "/api/ZzyjTradePayApply/takeEffect")
    public CommonResponse<ZzyjTradePayApplyVO> takeEffect(@RequestBody ZzyjTradePayApplyVO zzyjTradePayApplyVO) {
        logger.info("进入商贸公司付款系统！");
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        try {
            key = getLockKey(zzyjTradePayApplyVO);
            jedis = jedisPool.getResource();
            while(!lock && retryTime <= maxRetryTime) {
                if(retryTime >0 ){
                    logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                    Thread.sleep(retryTime * retryInterval);
                }
                retryTime++;
                lock = getLock(key, jedis);
            }
            if(!lock && retryTime > maxRetryTime) {
                logger.info("键-{}第{}次尝试获取redis锁失败，已达到最大尝试次数，本次核销失败！", key, retryTime);
                return CommonResponse.error("付款结果处理失败!");
            }

            return pmPayService.takeEffect(zzyjTradePayApplyVO);
        } catch (Exception e) {
            logger.error("付款结果处理失败！ZzyjTradePayApplyVO-{}", JSONObject.toJSONString(zzyjTradePayApplyVO));
            return CommonResponse.error("付款结果处理失败!");
        } finally {
            //释放单据锁
            RedisUtil.unLock(jedis, false, key, OPERATE);
            logger.info("redisKey-{}进行Redis锁释放", key);
        }
    }

    // 付款申请弃审/关闭
    @PostMapping(value = "/api/ZzyjTradePayApply/abandonOrClose")
    public CommonResponse<ZzyjTradePayApplyVO> abandonOrClose(@RequestBody ZzyjTradePayApplyVO zzyjTradePayApplyVO) {
        logger.info("进入商贸公司付款系统！");
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        try {
            key = getLockKey(zzyjTradePayApplyVO);
            jedis = jedisPool.getResource();
            while(!lock && retryTime <= maxRetryTime) {
                if(retryTime >0 ){
                    logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                    Thread.sleep(retryTime * retryInterval);
                }
                retryTime++;
                lock = getLock(key, jedis);
            }

            if(!lock && retryTime > maxRetryTime) {
                logger.info("键-{}第{}次尝试获取redis锁失败，已达到最大尝试次数，本次弃审/关闭失败！", key, retryTime);
                return CommonResponse.error("付款结果处理失败!");
            }

            return pmPayService.abandonOrClose(zzyjTradePayApplyVO);
        } catch (Exception e) {
            logger.error("付款结果处理失败！zzyjTradePayApplyVO-{}", JSONObject.toJSONString(zzyjTradePayApplyVO));
            return CommonResponse.error("付款结果处理失败!");
        } finally {
            //释放单据锁
            RedisUtil.unLock(jedis, false, key, OPERATE);
            logger.info("redisKey-{}进行Redis锁释放", key);
        }
    }

    // 付款申请核销
    @PostMapping(value = "/api/ZzyjTradePayApply/writeOff")
    public CommonResponse<ZzyjTradePayApplyVO> writeOff(@RequestBody ZzyjTradePayApplyVO zzyjTradePayApplyVO) {
        logger.info("进入商贸公司付款系统！");
        Jedis jedis = null;
        String key = null;
        int retryTime = 0;
        boolean lock = false;
        try {
            key = getLockKey(zzyjTradePayApplyVO);
            jedis = jedisPool.getResource();
            while(!lock && retryTime <= maxRetryTime) {
                if(retryTime > 0){
                    logger.info("键-{}第{}次尝试获取redis锁, 第{}毫秒后开始尝试", key, retryTime, retryTime * retryInterval);
                    Thread.sleep(retryTime * retryInterval);
                }
                retryTime++;
                lock = getLock(key, jedis);
            }

            if(!lock && retryTime > maxRetryTime) {
                logger.info("键-{}第{}次尝试获取redis锁失败，已达到最大尝试次数，本次弃审/关闭失败！", key, retryTime);
                return CommonResponse.error("付款结果处理失败!");
            }

            return pmPayService.writeOff(zzyjTradePayApplyVO);
        } catch (Exception e) {
            logger.error("付款结果处理失败！zzyjTradePayApplyVO-{}", JSONObject.toJSONString(zzyjTradePayApplyVO));
            return CommonResponse.error("付款结果处理失败! ");
        } finally {
            //释放单据锁
            RedisUtil.unLock(jedis, false, key, OPERATE);
            logger.info("redisKey-{}进行Redis锁释放", key);
        }
    }

    private String getLockKey(ZzyjTradePayApplyVO zzyjTradePayApplyVO) {
        logger.info("处理付款数据-{}前加锁", JSONObject.toJSONString(zzyjTradePayApplyVO));
        // 根据数据维度获取锁，维度：项目ID、供应商ID、合同登记ID、收款单位ID
        String redisKey = "PM::"+zzyjTradePayApplyVO.getProjectId() + "::" + zzyjTradePayApplyVO.getSupplierId() + "::" + zzyjTradePayApplyVO.getContractRegisterId() + "::" + zzyjTradePayApplyVO.getPayeeId();
        logger.info("对保存操作添加Redis锁，redisKey-{}", redisKey);
        return redisKey;
    }

    private Boolean getLock(String key, Jedis jedis) {
        logger.info("从jedisPool获取jedis对象，jedis对象-{}", jedis);
        try {
            // 在数据维度层面进行加锁
            return RedisTool.tryLock(jedis, key, OPERATE, 600);
        } catch (Exception e) {
            logger.info("根据键-{}获取reids锁异常", key, e);
            return false;
        }
    }

    /**
     * 根据参数查询财务中间表信息
     *
     * @param projectId 项目ID
     * @param supplyId 供应商Id
     * @param contractId 合同Id
     * @param payeeId 收款方Id
     * @return
     */
    @GetMapping(value = "/api/ZzyjTradePayApply/getPaymentDetail")
    public CommonResponse<ZzyjTradePayApplyVO> getPaymentDetail(@RequestParam Long projectId,
                                                       @RequestParam Long supplyId,
                                                       @RequestParam Long contractId,
                                                       @RequestParam Long payeeId) {
        logger.info("进入商贸公司付款系统！");
        QueryWrapper<ZzyjTradePayApplyEntity> query = new QueryWrapper<>();
        query.eq("XMID", projectId);
        query.eq("GYSID", supplyId);
        query.eq("HTDJID", contractId);
        query.eq("SKF", payeeId);

        ZzyjTradePayApplyEntity paymentDetail = pmPayService.getOne(query);
        if(null != paymentDetail) {
            return CommonResponse.success(BeanMapper.map(paymentDetail, ZzyjTradePayApplyVO.class));
        }

        return CommonResponse.success("未查询到匹配付款信息！", null);
    }


    @PostMapping(value = "/api/ZzyjTradePayApply/dailyFinanceInfo")
    public CommonResponse<List<Map<String, Object>>> dailyFinanceInfo(@RequestBody String dateStr) {
        logger.info("进入商贸公司付款系统！");
        return CommonResponse.success(pmPayService.dailyFinanceInfo(dateStr));
    }

}
