package com.ejianc.business.laborservice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 劳务公司收入合同收款登记
 * 
 * @author generator
 * 
 */
public class LaborserviceIncomeReceivingVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long incomeContractId; // 收入合同id
    private String incomeContractCode; // 收入合同编号
    private String incomeContractName; // 收入合同名称
    private String contractStatus; // 合同状态
    private Long firstPartyId; // 甲方id
    private String firstPartyName; // 甲方
    private Long payerId; // 付款单位id
    private String payerName; // 付款单位
    private Long supplierId; // 乙方id
    private String supplierName; // 乙方
    private Long bankAccountId; //银行账户id
    private String bankAccountName; //银行账户名称
    private Long receivingBankId; // 收款银行id
    private String receivingBankName; // 收款银行
    private Long bankNum; // 收款账号
    private Long supplierSignerId; // 乙方签订人id
    private String supplierSignerName; // 乙方签订人
    private Long projectManagerDeptId; // 项目管理部id
    private String projectManagerDept; // 项目管理部
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private String projectAddress; // 项目地址
    private BigDecimal contractAccumulateTaxMny; // 合同累计含税金额
    private BigDecimal accmulateCollectionAmount; // 合同累计已收款金额
    private BigDecimal receivingAmount; // 本次收款金额
    private BigDecimal writeOffAmount; // 核销金额
    private BigDecimal managementFees; // 管理费
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receivingDate; //签订日期
    private String receivingType; //收款类型（工程款、劳务费、投标保证金、质保金、代发工资、税金及管理费、存款计息、借款、其他）
    private String receivingMethod;//收款方式（银行存款、现金、电子银行承兑汇票、银行承兑汇票、商业承兑汇票、信用证、供应链收款、以物抵账、其他）
    private Long expendContractId; //支出合同id
    private String expendContractName; //支出合同名称
    private BigDecimal managementRate; //支出合同对应的管理费率

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "labor_income_contract_ref")
    public Long getIncomeContractId() {
        return incomeContractId;
    }
    @ReferDeserialTransfer
    public void setIncomeContractId(Long incomeContractId) {
        this.incomeContractId = incomeContractId;
    }
    public String getIncomeContractCode() {
        return incomeContractCode;
    }

    public void setIncomeContractCode(String incomeContractCode) {
        this.incomeContractCode = incomeContractCode;
    }
    public String getIncomeContractName() {
        return incomeContractName;
    }

    public void setIncomeContractName(String incomeContractName) {
        this.incomeContractName = incomeContractName;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getFirstPartyId() {
        return firstPartyId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getPayerId() {
        return payerId;
    }
    @ReferDeserialTransfer
    public void setPayerId(Long payerId) {
        this.payerId = payerId;
    }
    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    @ReferSerialTransfer(referCode = "support-bank-account")
    public Long getBankAccountId() {
        return bankAccountId;
    }
    @ReferDeserialTransfer
    public void setBankAccountId(Long bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public String getBankAccountName() {
        return bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public Long getReceivingBankId() {
        return receivingBankId;
    }

    public void setReceivingBankId(Long receivingBankId) {
        this.receivingBankId = receivingBankId;
    }
    public String getReceivingBankName() {
        return receivingBankName;
    }

    public void setReceivingBankName(String receivingBankName) {
        this.receivingBankName = receivingBankName;
    }
    public Long getBankNum() {
        return bankNum;
    }

    public void setBankNum(Long bankNum) {
        this.bankNum = bankNum;
    }
    public Long getSupplierSignerId() {
        return supplierSignerId;
    }

    public void setSupplierSignerId(Long supplierSignerId) {
        this.supplierSignerId = supplierSignerId;
    }
    public String getSupplierSignerName() {
        return supplierSignerName;
    }

    public void setSupplierSignerName(String supplierSignerName) {
        this.supplierSignerName = supplierSignerName;
    }
    public Long getProjectManagerDeptId() {
        return projectManagerDeptId;
    }

    public void setProjectManagerDeptId(Long projectManagerDeptId) {
        this.projectManagerDeptId = projectManagerDeptId;
    }
    public String getProjectManagerDept() {
        return projectManagerDept;
    }

    public void setProjectManagerDept(String projectManagerDept) {
        this.projectManagerDept = projectManagerDept;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public BigDecimal getContractAccumulateTaxMny() {
        return contractAccumulateTaxMny;
    }

    public void setContractAccumulateTaxMny(BigDecimal contractAccumulateTaxMny) {
        this.contractAccumulateTaxMny = contractAccumulateTaxMny;
    }
    public BigDecimal getAccmulateCollectionAmount() {
        return accmulateCollectionAmount;
    }

    public void setAccmulateCollectionAmount(BigDecimal accmulateCollectionAmount) {
        this.accmulateCollectionAmount = accmulateCollectionAmount;
    }
    public BigDecimal getReceivingAmount() {
        return receivingAmount;
    }

    public void setReceivingAmount(BigDecimal receivingAmount) {
        this.receivingAmount = receivingAmount;
    }
    public BigDecimal getWriteOffAmount() {
        return writeOffAmount;
    }

    public void setWriteOffAmount(BigDecimal writeOffAmount) {
        this.writeOffAmount = writeOffAmount;
    }
    public BigDecimal getManagementFees() {
        return managementFees;
    }

    public void setManagementFees(BigDecimal managementFees) {
        this.managementFees = managementFees;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getReceivingDate() {
        return receivingDate;
    }

    public void setReceivingDate(Date receivingDate) {
        this.receivingDate = receivingDate;
    }

    public String getReceivingType() {
        return receivingType;
    }

    public void setReceivingType(String receivingType) {
        this.receivingType = receivingType;
    }

    public String getReceivingMethod() {
        return receivingMethod;
    }

    public void setReceivingMethod(String receivingMethod) {
        this.receivingMethod = receivingMethod;
    }

    @ReferSerialTransfer(referCode = "labor_expend_contract_ref")
    public Long getExpendContractId() {
        return expendContractId;
    }
    @ReferDeserialTransfer
    public void setExpendContractId(Long expendContractId) {
        this.expendContractId = expendContractId;
    }

    public String getExpendContractName() {
        return expendContractName;
    }

    public void setExpendContractName(String expendContractName) {
        this.expendContractName = expendContractName;
    }

    public BigDecimal getManagementRate() {
        return managementRate;
    }

    public void setManagementRate(BigDecimal managementRate) {
        this.managementRate = managementRate;
    }
}
