package com.ejianc.business.itax.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.itax.vo.SalaryDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工人工资上传
 * 
 * @author generator
 * 
 */
public class SalaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long operatorId; // 经办人ID
    private String operatorName; // 劳务队长人姓名
    private Long orgId; // 单位id
    private String orgName; // 单位名称
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目
    private String name; // 姓名
    private String phone; // 联系电话
    private BigDecimal moneySum; // 本次发放总金额
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date billTime; // 上传日期
    
    private List<SalaryDetailVO> salaryDetailList = new ArrayList<>(); // 工人工资上传明细
    private Long createUserId; // 创建人ID
    private Date submitTime; // 生效时间

    private Long expendContractId; // 支出合同id
    private String expendContractName; // 支出合同名称
    private String expendContractCode; // 支出合同编号
    private String parentOrgName; // 项目管理部名称


    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode = "labor_expend_contract_ref")
    public Long getExpendContractId() {
        return expendContractId;
    }
    @ReferDeserialTransfer
    public void setExpendContractId(Long expendContractId) {
        this.expendContractId = expendContractId;
    }

    public String getExpendContractName() {
        return expendContractName;
    }

    public void setExpendContractName(String expendContractName) {
        this.expendContractName = expendContractName;
    }

    public String getExpendContractCode() {
        return expendContractCode;
    }

    public void setExpendContractCode(String expendContractCode) {
        this.expendContractCode = expendContractCode;
    }

    public Date getSubmitTime() {
        return submitTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public BigDecimal getMoneySum() {
        return moneySum;
    }

    public void setMoneySum(BigDecimal moneySum) {
        this.moneySum = moneySum;
    }
    public Date getBillTime() {
        return billTime;
    }

    public void setBillTime(Date billTime) {
        this.billTime = billTime;
    }
    
     public List<SalaryDetailVO> getSalaryDetailList() {
        return salaryDetailList;
     }

     public void setSalaryDetailList(List<SalaryDetailVO> salaryDetailList) {
        this.salaryDetailList = salaryDetailList;
     }
}
