package com.ejianc.business.bid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 劳务公司-投标结果登记
 * 
 * @author generator
 * 
 */
public class BidResultVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String projectId; // 项目
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date serviceDate; // 业务日期
    private Long bidOrgId; // 招标单位
    private String bidOrgName; // 招标单位名称
    private Long infoSource; // 信息来源
    private BigDecimal planMny; // 预计承揽金额
    private String planMode; // 预计项目总规模
    private String area; // 地区
    private String address; // 工程地点
    private String province; // 省份
    private String city; // 市
    private String region; // 区县
    private String adcode; // 区划编码
    private Long firstParty; // 甲方
    private String firstPartyName; // 甲方名称
    private String firstPartyType; // 甲方单位性质
    private Long biddingOrg; // 招标单位
    private String biddingOrgName; // 招标单位名称
    private String projectType; // 工程类型
    private String bidType; // 投标形式
    private BigDecimal bidMny; // 投标价格
    private BigDecimal trueBidMny; // 实际中标价格
    private String bidResult; // 开标结果
    private String mainRemark; // 主要情况描述
    private Long bidId; // 投标id
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }
    public Long getBidOrgId() {
        return bidOrgId;
    }

    public void setBidOrgId(Long bidOrgId) {
        this.bidOrgId = bidOrgId;
    }
    public String getBidOrgName() {
        return bidOrgName;
    }

    public void setBidOrgName(String bidOrgName) {
        this.bidOrgName = bidOrgName;
    }
    public Long getInfoSource() {
        return infoSource;
    }

    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }
    public BigDecimal getPlanMny() {
        return planMny;
    }

    public void setPlanMny(BigDecimal planMny) {
        this.planMny = planMny;
    }
    public String getPlanMode() {
        return planMode;
    }

    public void setPlanMode(String planMode) {
        this.planMode = planMode;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
    public String getAdcode() {
        return adcode;
    }

    public void setAdcode(String adcode) {
        this.adcode = adcode;
    }
    public Long getFirstParty() {
        return firstParty;
    }

    public void setFirstParty(Long firstParty) {
        this.firstParty = firstParty;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    public String getFirstPartyType() {
        return firstPartyType;
    }

    public void setFirstPartyType(String firstPartyType) {
        this.firstPartyType = firstPartyType;
    }
    public Long getBiddingOrg() {
        return biddingOrg;
    }

    public void setBiddingOrg(Long biddingOrg) {
        this.biddingOrg = biddingOrg;
    }
    public String getBiddingOrgName() {
        return biddingOrgName;
    }

    public void setBiddingOrgName(String biddingOrgName) {
        this.biddingOrgName = biddingOrgName;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getBidType() {
        return bidType;
    }

    public void setBidType(String bidType) {
        this.bidType = bidType;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public BigDecimal getTrueBidMny() {
        return trueBidMny;
    }

    public void setTrueBidMny(BigDecimal trueBidMny) {
        this.trueBidMny = trueBidMny;
    }
    public String getBidResult() {
        return bidResult;
    }

    public void setBidResult(String bidResult) {
        this.bidResult = bidResult;
    }
    public String getMainRemark() {
        return mainRemark;
    }

    public void setMainRemark(String mainRemark) {
        this.mainRemark = mainRemark;
    }
    @ReferSerialTransfer(referCode="labor-bid-enroll")
    public Long getBidId() {
        return bidId;
    }
    @ReferDeserialTransfer
    public void setBidId(Long bidId) {
        this.bidId = bidId;
    }
    
}
