package com.ejianc.business.laborsettle.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 节点对账应收
 * 
 * @author generator
 * 
 */
public class NodeSettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long incomeContractId; // 合同id
    private String incomeContractCode; // 合同编号
    private String incomeContractName; // 合同名称
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private BigDecimal contractAccumulateTaxMny; // 合同含税金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleTime; // 结算日期
    private BigDecimal totalMonthSettleMoney; // 累计月度节点结算金额
    private BigDecimal settleMoney; // 本次结算合计
    private BigDecimal totalSettleMoney; // 累计节点结算金额
    private BigDecimal returnMoney; // 报送确认金额
    private String returnState; // 报送状态
    private BigDecimal contractSettleMoney; // 合同履约金额
    private BigDecimal oldJobSettleMoney; // 零工金额
    private BigDecimal rewardMoney; // 奖罚金额
    private BigDecimal otherMoney; // 其他金额
    private String settleType; // 结算类型

    public String getSettleType() {
        return settleType;
    }

    public void setSettleType(String settleType) {
        this.settleType = settleType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @ReferSerialTransfer(referCode = "labor_income_contract_ref")
    public Long getIncomeContractId() {
        return incomeContractId;
    }
    @ReferDeserialTransfer
    public void setIncomeContractId(Long incomeContractId) {
        this.incomeContractId = incomeContractId;
    }
    public String getIncomeContractCode() {
        return incomeContractCode;
    }

    public void setIncomeContractCode(String incomeContractCode) {
        this.incomeContractCode = incomeContractCode;
    }
    public String getIncomeContractName() {
        return incomeContractName;
    }

    public void setIncomeContractName(String incomeContractName) {
        this.incomeContractName = incomeContractName;
    }

    @ReferSerialTransfer(referCode = "labor_project_ref")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getContractAccumulateTaxMny() {
        return contractAccumulateTaxMny;
    }

    public void setContractAccumulateTaxMny(BigDecimal contractAccumulateTaxMny) {
        this.contractAccumulateTaxMny = contractAccumulateTaxMny;
    }
    public Date getSettleTime() {
        return settleTime;
    }

    public void setSettleTime(Date settleTime) {
        this.settleTime = settleTime;
    }
    public BigDecimal getTotalMonthSettleMoney() {
        return totalMonthSettleMoney;
    }

    public void setTotalMonthSettleMoney(BigDecimal totalMonthSettleMoney) {
        this.totalMonthSettleMoney = totalMonthSettleMoney;
    }
    public BigDecimal getSettleMoney() {
        return settleMoney;
    }

    public void setSettleMoney(BigDecimal settleMoney) {
        this.settleMoney = settleMoney;
    }
    public BigDecimal getTotalSettleMoney() {
        return totalSettleMoney;
    }

    public void setTotalSettleMoney(BigDecimal totalSettleMoney) {
        this.totalSettleMoney = totalSettleMoney;
    }
    public BigDecimal getReturnMoney() {
        return returnMoney;
    }

    public void setReturnMoney(BigDecimal returnMoney) {
        this.returnMoney = returnMoney;
    }
    public String getReturnState() {
        return returnState;
    }

    public void setReturnState(String returnState) {
        this.returnState = returnState;
    }
    public BigDecimal getContractSettleMoney() {
        return contractSettleMoney;
    }

    public void setContractSettleMoney(BigDecimal contractSettleMoney) {
        this.contractSettleMoney = contractSettleMoney;
    }
    public BigDecimal getOldJobSettleMoney() {
        return oldJobSettleMoney;
    }

    public void setOldJobSettleMoney(BigDecimal oldJobSettleMoney) {
        this.oldJobSettleMoney = oldJobSettleMoney;
    }
    public BigDecimal getRewardMoney() {
        return rewardMoney;
    }

    public void setRewardMoney(BigDecimal rewardMoney) {
        this.rewardMoney = rewardMoney;
    }
    public BigDecimal getOtherMoney() {
        return otherMoney;
    }

    public void setOtherMoney(BigDecimal otherMoney) {
        this.otherMoney = otherMoney;
    }
    
}
