package com.ejianc.business.laborservice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 劳务公司支出合同
 * 
 * @author generator
 * 
 */
public class LaborserviceExpendContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private String contractStatus; // 合同状态(正常,中止,作废)
    private Long contractId; // 合同id
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private Long incomeContractId;//收入合同id
    private String incomeContractCode; // 收入合同编号
    private String incomeContractName;//收入合同名称
    private Long firstPartyId; // 甲方id
    private String firstPartyName; // 甲方
    private String supplierId; // 乙方id
    private String supplier; // 乙方
    private String supplierSignerCertId; // 乙方签订人身份证编号
    /*private Long supplierSignerId; //乙方签订人id
    private String supplierSigner;//乙方签订人*/
    private String supplierPhone; // 乙方签订人电话
    private Long projectManagerDeptId; // 项目管理部id
    private String projectManagerDept; // 项目管理部
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private String projectAddress; // 项目地址
    private String invoiceTypeName; // 发票类型
    private BigDecimal taxRate; // 税率%
    private BigDecimal contractTaxMny; // 合同暂订含税金额
    private BigDecimal contractAccumulateTax; // 合同累计含税金额
    private BigDecimal managementRate; // 管理费率%
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private BigDecimal earlyAccmulateExpendAmount; // 期初累计付款金额
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String invoiceInfo; //发票备注信息
    private String areaId; // 地区
    private String areaName; // 地区名称

    private List<LaborserviceExpendContractZiVO> laborserviceExpendContractZiList = new ArrayList<>(); // 劳务公司支出合同子表
    private BigDecimal sumInvoiceAmount; // 累计开票金额
    private String incomeContractBillCode; // 收入合同单据编码
    private Long incomeContractFirstPartyId; // 收入合同甲方id
    private String incomeContractFirstPartyName; // 收入合同甲方名称

    private List<LaborserviceExpendContractIncomeZiVO> laborserviceExpendContractIncomeZiList = new ArrayList<>(); // 支出合同-收入合同子表

    private Integer num;
    private Integer year;
    private String contractType;

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public List<LaborserviceExpendContractIncomeZiVO> getLaborserviceExpendContractIncomeZiList() {
        return laborserviceExpendContractIncomeZiList;
    }

    public void setLaborserviceExpendContractIncomeZiList(List<LaborserviceExpendContractIncomeZiVO> laborserviceExpendContractIncomeZiList) {
        this.laborserviceExpendContractIncomeZiList = laborserviceExpendContractIncomeZiList;
    }

    public String getIncomeContractBillCode() {
        return incomeContractBillCode;
    }

    public void setIncomeContractBillCode(String incomeContractBillCode) {
        this.incomeContractBillCode = incomeContractBillCode;
    }

    public Long getIncomeContractFirstPartyId() {
        return incomeContractFirstPartyId;
    }

    public void setIncomeContractFirstPartyId(Long incomeContractFirstPartyId) {
        this.incomeContractFirstPartyId = incomeContractFirstPartyId;
    }

    public String getIncomeContractFirstPartyName() {
        return incomeContractFirstPartyName;
    }

    public void setIncomeContractFirstPartyName(String incomeContractFirstPartyName) {
        this.incomeContractFirstPartyName = incomeContractFirstPartyName;
    }

    public BigDecimal getSumInvoiceAmount() {
        return sumInvoiceAmount;
    }

    public void setSumInvoiceAmount(BigDecimal sumInvoiceAmount) {
        this.sumInvoiceAmount = sumInvoiceAmount;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode = "labor_income_contract_ref")
    public Long getIncomeContractId() {
        return incomeContractId;
    }
    @ReferDeserialTransfer
    public void setIncomeContractId(Long incomeContractId) {
        this.incomeContractId = incomeContractId;
    }

    public String getIncomeContractName() {
        return incomeContractName;
    }

    public void setIncomeContractName(String incomeContractName) {
        this.incomeContractName = incomeContractName;
    }

    public String getIncomeContractCode() {
        return incomeContractCode;
    }

    public void setIncomeContractCode(String incomeContractCode) {
        this.incomeContractCode = incomeContractCode;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getFirstPartyId() {
        return firstPartyId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
   // @ReferSerialTransfer(referCode = "laborservice_team_ref")
    public String getSupplierId() {
        return supplierId;
    }
    //@ReferDeserialTransfer
    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }
   /* //@ReferSerialTransfer(referCode = "laborservice_team_ref")
    public Long getSupplierSignerId() {
        return supplierSignerId;
    }
    //@ReferDeserialTransfer
    public void setSupplierSignerId(Long supplierSignerId) {
        this.supplierSignerId = supplierSignerId;
    }

    public String getSupplierSigner() {
        return supplierSigner;
    }

    public void setSupplierSigner(String supplierSigner) {
        this.supplierSigner = supplierSigner;
    }*/

    public String getSupplierSignerCertId() {
        return supplierSignerCertId;
    }

    public void setSupplierSignerCertId(String supplierSignerCertId) {
        this.supplierSignerCertId = supplierSignerCertId;
    }
    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getProjectManagerDeptId() {
        return projectManagerDeptId;
    }
    @ReferDeserialTransfer
    public void setProjectManagerDeptId(Long projectManagerDeptId) {
        this.projectManagerDeptId = projectManagerDeptId;
    }
    public String getProjectManagerDept() {
        return projectManagerDept;
    }

    public void setProjectManagerDept(String projectManagerDept) {
        this.projectManagerDept = projectManagerDept;
    }
    @ReferSerialTransfer(referCode = "labor_project_ref")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractAccumulateTax() {
        return contractAccumulateTax;
    }

    public void setContractAccumulateTax(BigDecimal contractAccumulateTax) {
        this.contractAccumulateTax = contractAccumulateTax;
    }
    public BigDecimal getManagementRate() {
        return managementRate;
    }

    public void setManagementRate(BigDecimal managementRate) {
        this.managementRate = managementRate;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getEarlyAccmulateExpendAmount() {
        return earlyAccmulateExpendAmount;
    }

    public void setEarlyAccmulateExpendAmount(BigDecimal earlyAccmulateExpendAmount) {
        this.earlyAccmulateExpendAmount = earlyAccmulateExpendAmount;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getInvoiceInfo() {
        return invoiceInfo;
    }

    public void setInvoiceInfo(String invoiceInfo) {
        this.invoiceInfo = invoiceInfo;
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public List<LaborserviceExpendContractZiVO> getLaborserviceExpendContractZiList() {
        return laborserviceExpendContractZiList;
    }

    public void setLaborserviceExpendContractZiList(List<LaborserviceExpendContractZiVO> laborserviceExpendContractZiList) {
        this.laborserviceExpendContractZiList = laborserviceExpendContractZiList;
    }
}
