package com.ejianc.business.laborservice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.elasticsearch.search.DocValueFormat;


/**
 * 劳务公司发票申请
 * 
 * @author generator
 * 
 */
public class LaborserviceInvoiceApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private String contractBillCode; // 单据编号
    private Date contractBillDate; // 单据日期
    private String contractBillCreatorCode; // 制单人账号
    private String contractBillCreator; // 制单人
    private String contractStatus; // 合同状态(正常、终止、作废)
    private Long incomeContractId; // 收入合同id
    private String incomeContractCode; // 收入合同编号
    private String incomeContractName; // 收入合同名称
    private Long firstPartyId; // 甲方id
    private String firstPartyName; // 甲方
    private Long projectManagerDeptId; // 项目管理部id
    private String projectManagerDept; // 项目管理部
    private String supplierSignerName; // 乙方签订人
    private String supplierSignerCertId; // 乙方签订人身份证编号
    private Long supplierPhone; // 乙方签订人电话
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private String projectAddress; // 项目地址
    private String invoiceTypeName; // 发票类型(专票、普票)
    private BigDecimal taxRate; // 税率%
    private BigDecimal contractAccumulateTaxMny; // 合同累计含税金额
    private BigDecimal managementRate; // 管理费率%
    private BigDecimal contractAccmulateInvoiceAmount; // 合同累计已开票金额
    private BigDecimal applyInvoiceAmount; // 本次申请开票金额
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private BigDecimal totalInvoicedAmount;//含本次开票合计
    private BigDecimal totalInvoicedAmountRate; //含本次开票占和同比
    private String invoiceTitle; //开票主题
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date curApplyDate; //本次开票日期

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractBillCode() {
        return contractBillCode;
    }

    public void setContractBillCode(String contractBillCode) {
        this.contractBillCode = contractBillCode;
    }
    public Date getContractBillDate() {
        return contractBillDate;
    }

    public void setContractBillDate(Date contractBillDate) {
        this.contractBillDate = contractBillDate;
    }
    public String getContractBillCreatorCode() {
        return contractBillCreatorCode;
    }

    public void setContractBillCreatorCode(String contractBillCreatorCode) {
        this.contractBillCreatorCode = contractBillCreatorCode;
    }
    public String getContractBillCreator() {
        return contractBillCreator;
    }

    public void setContractBillCreator(String contractBillCreator) {
        this.contractBillCreator = contractBillCreator;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    @ReferSerialTransfer(referCode = "labor_income_contract_ref")
    public Long getIncomeContractId() {
        return incomeContractId;
    }
    @ReferDeserialTransfer
    public void setIncomeContractId(Long incomeContractId) {
        this.incomeContractId = incomeContractId;
    }
    public String getIncomeContractCode() {
        return incomeContractCode;
    }

    public void setIncomeContractCode(String incomeContractCode) {
        this.incomeContractCode = incomeContractCode;
    }
    public String getIncomeContractName() {
        return incomeContractName;
    }

    public void setIncomeContractName(String incomeContractName) {
        this.incomeContractName = incomeContractName;
    }
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    public Long getProjectManagerDeptId() {
        return projectManagerDeptId;
    }

    public void setProjectManagerDeptId(Long projectManagerDeptId) {
        this.projectManagerDeptId = projectManagerDeptId;
    }
    public String getProjectManagerDept() {
        return projectManagerDept;
    }

    public void setProjectManagerDept(String projectManagerDept) {
        this.projectManagerDept = projectManagerDept;
    }
    public String getSupplierSignerName() {
        return supplierSignerName;
    }

    public void setSupplierSignerName(String supplierSignerName) {
        this.supplierSignerName = supplierSignerName;
    }
    public String getSupplierSignerCertId() {
        return supplierSignerCertId;
    }

    public void setSupplierSignerCertId(String supplierSignerCertId) {
        this.supplierSignerCertId = supplierSignerCertId;
    }
    public Long getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(Long supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getContractAccumulateTaxMny() {
        return contractAccumulateTaxMny;
    }

    public void setContractAccumulateTaxMny(BigDecimal contractAccumulateTaxMny) {
        this.contractAccumulateTaxMny = contractAccumulateTaxMny;
    }
    public BigDecimal getManagementRate() {
        return managementRate;
    }

    public void setManagementRate(BigDecimal managementRate) {
        this.managementRate = managementRate;
    }
    public BigDecimal getContractAccmulateInvoiceAmount() {
        return contractAccmulateInvoiceAmount;
    }

    public void setContractAccmulateInvoiceAmount(BigDecimal contractAccmulateInvoiceAmount) {
        this.contractAccmulateInvoiceAmount = contractAccmulateInvoiceAmount;
    }
    public BigDecimal getApplyInvoiceAmount() {
        return applyInvoiceAmount;
    }

    public void setApplyInvoiceAmount(BigDecimal applyInvoiceAmount) {
        this.applyInvoiceAmount = applyInvoiceAmount;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getTotalInvoicedAmount() {
        return totalInvoicedAmount;
    }

    public void setTotalInvoicedAmount(BigDecimal totalInvoicedAmount) {
        this.totalInvoicedAmount = totalInvoicedAmount;
    }

    public BigDecimal getTotalInvoicedAmountRate() {
        return totalInvoicedAmountRate;
    }

    public void setTotalInvoicedAmountRate(BigDecimal totalInvoicedAmountRate) {
        this.totalInvoicedAmountRate = totalInvoicedAmountRate;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public Date getCurApplyDate() {
        return curApplyDate;
    }

    public void setCurApplyDate(Date curApplyDate) {
        this.curApplyDate = curApplyDate;
    }
}
