package com.ejianc.business.laborservice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 支出申请
 * 
 * @author generator
 * 
 */
public class ExpendApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long incomeContractId; // 支出合同id
    private String incomeContractCode; // 支出合同编号
    private String incomeContractName; // 支出合同名称
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private Long firstPartyId; // 甲方id
    private String firstPartyName; // 甲方
    private Long supplierId; // 乙方id
    private String supplierName; // 乙方
    private Long supplierSignerId; // 乙方签订人id
    private String supplierSignerName; // 乙方签订人
    private String laborIdcard; // 签订人身份证号
    private BigDecimal contractAccumulateTaxMny; // 合同累计含税金额
    private String expendType; // 支付类型
    private String billSource; // 单据来源：自动生成、人工制单
    private String billSourceId; // 单据来源id
    private BigDecimal expendAmount; // 本次支出金额
    private BigDecimal totalSettleMoney; // 累计结算金额
    private BigDecimal totalExpendAmount; // 累计支出金额
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String contractStatus; // 合同状态


    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "labor_expend_contract_ref")
    public Long getIncomeContractId() {
        return incomeContractId;
    }
    @ReferDeserialTransfer
    public void setIncomeContractId(Long incomeContractId) {
        this.incomeContractId = incomeContractId;
    }
    public String getIncomeContractCode() {
        return incomeContractCode;
    }

    public void setIncomeContractCode(String incomeContractCode) {
        this.incomeContractCode = incomeContractCode;
    }
    public String getIncomeContractName() {
        return incomeContractName;
    }

    public void setIncomeContractName(String incomeContractName) {
        this.incomeContractName = incomeContractName;
    }

    @ReferSerialTransfer(referCode = "labor_project_ref")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getFirstPartyId() {
        return firstPartyId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierSignerId() {
        return supplierSignerId;
    }

    public void setSupplierSignerId(Long supplierSignerId) {
        this.supplierSignerId = supplierSignerId;
    }
    public String getSupplierSignerName() {
        return supplierSignerName;
    }

    public void setSupplierSignerName(String supplierSignerName) {
        this.supplierSignerName = supplierSignerName;
    }
    public String getLaborIdcard() {
        return laborIdcard;
    }

    public void setLaborIdcard(String laborIdcard) {
        this.laborIdcard = laborIdcard;
    }
    public BigDecimal getContractAccumulateTaxMny() {
        return contractAccumulateTaxMny;
    }

    public void setContractAccumulateTaxMny(BigDecimal contractAccumulateTaxMny) {
        this.contractAccumulateTaxMny = contractAccumulateTaxMny;
    }
    public String getExpendType() {
        return expendType;
    }

    public void setExpendType(String expendType) {
        this.expendType = expendType;
    }
    public String getBillSource() {
        return billSource;
    }

    public void setBillSource(String billSource) {
        this.billSource = billSource;
    }
    public String getBillSourceId() {
        return billSourceId;
    }

    public void setBillSourceId(String billSourceId) {
        this.billSourceId = billSourceId;
    }
    public BigDecimal getExpendAmount() {
        return expendAmount;
    }

    public void setExpendAmount(BigDecimal expendAmount) {
        this.expendAmount = expendAmount;
    }
    public BigDecimal getTotalSettleMoney() {
        return totalSettleMoney;
    }

    public void setTotalSettleMoney(BigDecimal totalSettleMoney) {
        this.totalSettleMoney = totalSettleMoney;
    }
    public BigDecimal getTotalExpendAmount() {
        return totalExpendAmount;
    }

    public void setTotalExpendAmount(BigDecimal totalExpendAmount) {
        this.totalExpendAmount = totalExpendAmount;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
}
