package com.ejianc.business.laborservice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 外经证登记
 * 
 * @author generator
 * 
 */
public class OutboundVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private String outboundStatus; // 外经证状态（正常、注消、延期）
    private Long expendContractId; // 支出合同id
    private String expendContractCode; // 支出合同编号
    private String expendContractName; // 支出合同名称
    private Long firstPartyId; // 合同相对方id
    private String firstPartyName; // 合同相对方
    private Long projectId; // 项目id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private String projectAddress; // 建筑服务发生地
    private BigDecimal contractAccumulateTax; // 合同金额(含税)
    private Long supplierId; // 劳务队长id
    private String supplierName; // 劳务队长名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date expirationStartDate; // 有效期开始
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date expirationEndDate; // 有效期结束
    private BigDecimal mny; // 开具金额
    private BigDecimal totalMny; // 累计开具金额
    private String outboundAddress; // 跨区域经营地街道乡镇
    private String byNumber; // 报验编号
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String operatorPhone; // 经办人联系方式

//    private List<OutboundChangeVO> outboundChangeList = new ArrayList<>(); // 外经证登记-变更
//
//
    public String getOperatorPhone() {
        return operatorPhone;
    }

    public void setOperatorPhone(String operatorPhone) {
        this.operatorPhone = operatorPhone;
    }

//    public List<OutboundChangeVO> getOutboundChangeList() {
//        return outboundChangeList;
//    }
//
//    public void setOutboundChangeList(List<OutboundChangeVO> outboundChangeList) {
//        this.outboundChangeList = outboundChangeList;
//    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getOutboundStatus() {
        return outboundStatus;
    }

    public void setOutboundStatus(String outboundStatus) {
        this.outboundStatus = outboundStatus;
    }

    @ReferSerialTransfer(referCode = "labor_expend_contract_ref")
    public Long getExpendContractId() {
        return expendContractId;
    }
    @ReferDeserialTransfer
    public void setExpendContractId(Long expendContractId) {
        this.expendContractId = expendContractId;
    }
    public String getExpendContractCode() {
        return expendContractCode;
    }

    public void setExpendContractCode(String expendContractCode) {
        this.expendContractCode = expendContractCode;
    }
    public String getExpendContractName() {
        return expendContractName;
    }

    public void setExpendContractName(String expendContractName) {
        this.expendContractName = expendContractName;
    }
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public BigDecimal getContractAccumulateTax() {
        return contractAccumulateTax;
    }

    public void setContractAccumulateTax(BigDecimal contractAccumulateTax) {
        this.contractAccumulateTax = contractAccumulateTax;
    }

    @ReferSerialTransfer(referCode = "laborservice_team_ref")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getExpirationStartDate() {
        return expirationStartDate;
    }

    public void setExpirationStartDate(Date expirationStartDate) {
        this.expirationStartDate = expirationStartDate;
    }
    public Date getExpirationEndDate() {
        return expirationEndDate;
    }

    public void setExpirationEndDate(Date expirationEndDate) {
        this.expirationEndDate = expirationEndDate;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public String getOutboundAddress() {
        return outboundAddress;
    }

    public void setOutboundAddress(String outboundAddress) {
        this.outboundAddress = outboundAddress;
    }
    public String getByNumber() {
        return byNumber;
    }

    public void setByNumber(String byNumber) {
        this.byNumber = byNumber;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
}
