package com.ejianc.business.laborservice.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 劳务公司收入合同
 * 
 * @author generator
 * 
 */
 @TableName("zzyj_laborservice_income_contract")
public class LaborserviceIncomeContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="contract_bill_code")
    private String contractBillCode; // 单据编号
    @TableField(value="contract_bill_date")
    private Date contractBillDate; // 单据日期
    @TableField(value="contract_bill_creator_code")
    private String contractBillCreatorCode; //制单人账号
    @TableField(value="contract_bill_creator")
    private String contractBillCreator; // 制单人
    @TableField(value="contract_status")
    private String contractStatus; // 合同状态(正常、终止、作废)
    @TableField(value="back_status")
    private String backStatus; // 返还情况(未返还、已返还)
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="inner_contract_id")
    private String innerContractId; // 内部合同号
    @TableField(value="first_party_id")
    private Long firstPartyId; // 甲方id
    @TableField(value="first_party_name")
    private String firstPartyName; // 甲方
    @TableField(value="project_manager_dept_id")
    private Long projectManagerDeptId; // 项目管理部id
    @TableField(value="project_manager_dept")
    private String projectManagerDept; // 项目管理部
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value="supplier")
    private String supplier; // 乙方
    @TableField(value = "supplier_signer_id")
    private Long supplierSignerId;//乙方签订人id
    @TableField(value="supplier_signer_name")
    private String supplierSignerName; // 乙方签订人
    @TableField(value="supplier_signer_cert_id")
    private String supplierSignerCertId; // 乙方签订人身份证编号
    @TableField(value="supplier_phone")
    private Long supplierPhone; // 乙方签订人电话
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_address")
    private String projectAddress; // 项目地址
    @TableField(value="invoice_type_id")
    private Long invoiceTypeId; // 发票类型id
    @TableField(value="invoice_type_name")
    private String invoiceTypeName; // 发票类型(专票、普票)
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率%
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同暂订含税金额
    @TableField(value="contract_accumulate_tax_mny")
    private BigDecimal contractAccumulateTaxMny; // 合同累计含税金额
    @TableField(value="contract_accumulate_mny")
    private BigDecimal contractAccumulateMny; // 合同累计不含税金额
    @TableField(value="contract_accumulate_tax")
    private BigDecimal contractAccumulateTax; // 合同累计税额
    @TableField(value="sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    @TableField(value="notes")
    private String notes; // 备忘
    @TableField(value="early_accmulate_invoe_amount")
    private BigDecimal earlyAccmulateInvoeAmount; // 期初累计开票金额
    @TableField(value="early_accmulate_collection_amount")
    private BigDecimal earlyAccmulateCollectionAmount; // 期初累计收款金额
    @TableField(value = "invoiced_amount")
    private BigDecimal invoicedAmount;//已累开发票金额
    @TableField(value="has_station_labor_manager")
    private String hasStationLaborManager; // 是否含派驻劳资员
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value = "business_status")
    private String businessStatus; //业务执行状态(执行中，完工待结，已结算，关闭)
    @TableField(value = "contract_type")
    private String contractType;//合同类型（内部，外部）
    @TableField(value = "storage_place")
    private String storagePlace;//存放处
    @TableField(value = "plaintiff_id")
    private Long plaintiffId;//原告id
    @TableField(value = "plaintiff_name")
    private String plaintiffName;//原告姓名
    @TableField(value = "defendant_id")
    private Long defendantId;//被告id
    @TableField(value = "defendant_name")
    private String defendantName;//被告姓名
    @TableField(value = "case_code")
    private String caseCode;//案号
    @TableField(value = "court_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date courtDate; // 开庭时间
    @TableField(value = "brief_appeal")
    private String briefAppeal; //简要诉求

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractBillCode() {
        return contractBillCode;
    }

    public void setContractBillCode(String contractBillCode) {
        this.contractBillCode = contractBillCode;
    }
    public Date getContractBillDate() {
        return contractBillDate;
    }

    public void setContractBillDate(Date contractBillDate) {
        this.contractBillDate = contractBillDate;
    }

    public String getContractBillCreatorCode() {
        return contractBillCreatorCode;
    }

    public void setContractBillCreatorCode(String contractBillCreatorCode) {
        this.contractBillCreatorCode = contractBillCreatorCode;
    }

    public String getContractBillCreator() {
        return contractBillCreator;
    }

    public void setContractBillCreator(String contractBillCreator) {
        this.contractBillCreator = contractBillCreator;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public String getBackStatus() {
        return backStatus;
    }

    public void setBackStatus(String backStatus) {
        this.backStatus = backStatus;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getInnerContractId() {
        return innerContractId;
    }

    public void setInnerContractId(String innerContractId) {
        this.innerContractId = innerContractId;
    }
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    public Long getProjectManagerDeptId() {
        return projectManagerDeptId;
    }

    public void setProjectManagerDeptId(Long projectManagerDeptId) {
        this.projectManagerDeptId = projectManagerDeptId;
    }
    public String getProjectManagerDept() {
        return projectManagerDept;
    }

    public void setProjectManagerDept(String projectManagerDept) {
        this.projectManagerDept = projectManagerDept;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Long getSupplierSignerId() {
        return supplierSignerId;
    }

    public void setSupplierSignerId(Long supplierSignerId) {
        this.supplierSignerId = supplierSignerId;
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }
    public String getSupplierSignerName() {
        return supplierSignerName;
    }

    public void setSupplierSignerName(String supplierSignerName) {
        this.supplierSignerName = supplierSignerName;
    }
    public String getSupplierSignerCertId() {
        return supplierSignerCertId;
    }

    public void setSupplierSignerCertId(String supplierSignerCertId) {
        this.supplierSignerCertId = supplierSignerCertId;
    }
    public Long getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(Long supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }

    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractAccumulateTaxMny() {
        return contractAccumulateTaxMny;
    }

    public void setContractAccumulateTaxMny(BigDecimal contractAccumulateTaxMny) {
        this.contractAccumulateTaxMny = contractAccumulateTaxMny;
    }
    public BigDecimal getContractAccumulateMny() {
        return contractAccumulateMny;
    }

    public void setContractAccumulateMny(BigDecimal contractAccumulateMny) {
        this.contractAccumulateMny = contractAccumulateMny;
    }
    public BigDecimal getContractAccumulateTax() {
        return contractAccumulateTax;
    }

    public void setContractAccumulateTax(BigDecimal contractAccumulateTax) {
        this.contractAccumulateTax = contractAccumulateTax;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getNotes() {
        return notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }
    public BigDecimal getEarlyAccmulateInvoeAmount() {
        return earlyAccmulateInvoeAmount;
    }

    public void setEarlyAccmulateInvoeAmount(BigDecimal earlyAccmulateInvoeAmount) {
        this.earlyAccmulateInvoeAmount = earlyAccmulateInvoeAmount;
    }
    public BigDecimal getEarlyAccmulateCollectionAmount() {
        return earlyAccmulateCollectionAmount;
    }

    public void setEarlyAccmulateCollectionAmount(BigDecimal earlyAccmulateCollectionAmount) {
        this.earlyAccmulateCollectionAmount = earlyAccmulateCollectionAmount;
    }

    public BigDecimal getInvoicedAmount() {
        return invoicedAmount;
    }

    public void setInvoicedAmount(BigDecimal invoicedAmount) {
        this.invoicedAmount = invoicedAmount;
    }

    public String getHasStationLaborManager() {
        return hasStationLaborManager;
    }

    public void setHasStationLaborManager(String hasStationLaborManager) {
        this.hasStationLaborManager = hasStationLaborManager;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public String getStoragePlace() {
        return storagePlace;
    }

    public void setStoragePlace(String storagePlace) {
        this.storagePlace = storagePlace;
    }

    public Long getPlaintiffId() {
        return plaintiffId;
    }

    public void setPlaintiffId(Long plaintiffId) {
        this.plaintiffId = plaintiffId;
    }

    public String getPlaintiffName() {
        return plaintiffName;
    }

    public void setPlaintiffName(String plaintiffName) {
        this.plaintiffName = plaintiffName;
    }

    public Long getDefendantId() {
        return defendantId;
    }

    public void setDefendantId(Long defendantId) {
        this.defendantId = defendantId;
    }

    public String getDefendantName() {
        return defendantName;
    }

    public void setDefendantName(String defendantName) {
        this.defendantName = defendantName;
    }

    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }

    public Date getCourtDate() {
        return courtDate;
    }

    public void setCourtDate(Date courtDate) {
        this.courtDate = courtDate;
    }

    public String getBriefAppeal() {
        return briefAppeal;
    }

    public void setBriefAppeal(String briefAppeal) {
        this.briefAppeal = briefAppeal;
    }
}
