package com.ejianc.business.laborservice.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 劳务公司收入合同收款登记
 * 
 * @author generator
 * 
 */
 @TableName("zzyj_laborservice_income_receiving")
public class LaborserviceIncomeReceivingEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="income_contract_id")
    private Long incomeContractId; // 收入合同id
    @TableField(value="income_contract_code")
    private String incomeContractCode; // 收入合同编号
    @TableField(value="income_contract_name")
    private String incomeContractName; // 收入合同名称
    @TableField(value="contract_status")
    private String contractStatus; // 合同状态
    @TableField(value="first_party_id")
    private Long firstPartyId; // 甲方id
    @TableField(value="first_party_name")
    private String firstPartyName; // 甲方
    @TableField(value="payer_id")
    private Long payerId; // 付款单位id
    @TableField(value="payer_name")
    private String payerName; // 付款单位
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方
    @TableField(value = "bank_account_id")
    private Long bankAccountId; //银行账户id
    @TableField(value = "bank_account_name")
    private String bankAccountName; //银行账户名称
    @TableField(value="receiving_bank_id")
    private Long receivingBankId; // 收款银行id
    @TableField(value="receiving_bank_name")
    private String receivingBankName; // 收款银行
    @TableField(value="bank_num")
    private Long bankNum; // 收款账号
    @TableField(value="supplier_signer_id")
    private Long supplierSignerId; // 乙方签订人id
    @TableField(value="supplier_signer_name")
    private String supplierSignerName; // 乙方签订人
    @TableField(value="project_manager_dept_id")
    private Long projectManagerDeptId; // 项目管理部id
    @TableField(value="project_manager_dept")
    private String projectManagerDept; // 项目管理部
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_address")
    private String projectAddress; // 项目地址
    @TableField(value="contract_accumulate_tax_mny")
    private BigDecimal contractAccumulateTaxMny; // 合同累计含税金额
    @TableField(value="accmulate_collection_amount")
    private BigDecimal accmulateCollectionAmount; // 合同累计已收款金额
    @TableField(value="receiving_amount")
    private BigDecimal receivingAmount; // 本次收款金额
    @TableField(value="write_off_amount")
    private BigDecimal writeOffAmount; // 核销金额
    @TableField(value="management_fees")
    private BigDecimal managementFees; // 管理费
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value = "receiving_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receivingDate; //签订日期
    @TableField(value = "receiving_type")
    private String receivingType; //收款类型（工程款、劳务费、投标保证金、质保金、代发工资、税金及管理费、存款计息、借款、其他）
    @TableField(value = "receiving_method")
    private String receivingMethod;//收款方式（银行存款、现金、电子银行承兑汇票、银行承兑汇票、商业承兑汇票、信用证、供应链收款、以物抵账、其他）
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getIncomeContractId() {
        return incomeContractId;
    }

    public void setIncomeContractId(Long incomeContractId) {
        this.incomeContractId = incomeContractId;
    }
    public String getIncomeContractCode() {
        return incomeContractCode;
    }

    public void setIncomeContractCode(String incomeContractCode) {
        this.incomeContractCode = incomeContractCode;
    }
    public String getIncomeContractName() {
        return incomeContractName;
    }

    public void setIncomeContractName(String incomeContractName) {
        this.incomeContractName = incomeContractName;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    public Long getPayerId() {
        return payerId;
    }

    public void setPayerId(Long payerId) {
        this.payerId = payerId;
    }
    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getBankAccountId() {
        return bankAccountId;
    }

    public void setBankAccountId(Long bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public String getBankAccountName() {
        return bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public Long getReceivingBankId() {
        return receivingBankId;
    }

    public void setReceivingBankId(Long receivingBankId) {
        this.receivingBankId = receivingBankId;
    }
    public String getReceivingBankName() {
        return receivingBankName;
    }

    public void setReceivingBankName(String receivingBankName) {
        this.receivingBankName = receivingBankName;
    }
    public Long getBankNum() {
        return bankNum;
    }

    public void setBankNum(Long bankNum) {
        this.bankNum = bankNum;
    }
    public Long getSupplierSignerId() {
        return supplierSignerId;
    }

    public void setSupplierSignerId(Long supplierSignerId) {
        this.supplierSignerId = supplierSignerId;
    }
    public String getSupplierSignerName() {
        return supplierSignerName;
    }

    public void setSupplierSignerName(String supplierSignerName) {
        this.supplierSignerName = supplierSignerName;
    }
    public Long getProjectManagerDeptId() {
        return projectManagerDeptId;
    }

    public void setProjectManagerDeptId(Long projectManagerDeptId) {
        this.projectManagerDeptId = projectManagerDeptId;
    }
    public String getProjectManagerDept() {
        return projectManagerDept;
    }

    public void setProjectManagerDept(String projectManagerDept) {
        this.projectManagerDept = projectManagerDept;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public BigDecimal getContractAccumulateTaxMny() {
        return contractAccumulateTaxMny;
    }

    public void setContractAccumulateTaxMny(BigDecimal contractAccumulateTaxMny) {
        this.contractAccumulateTaxMny = contractAccumulateTaxMny;
    }
    public BigDecimal getAccmulateCollectionAmount() {
        return accmulateCollectionAmount;
    }

    public void setAccmulateCollectionAmount(BigDecimal accmulateCollectionAmount) {
        this.accmulateCollectionAmount = accmulateCollectionAmount;
    }
    public BigDecimal getReceivingAmount() {
        return receivingAmount;
    }

    public void setReceivingAmount(BigDecimal receivingAmount) {
        this.receivingAmount = receivingAmount;
    }
    public BigDecimal getWriteOffAmount() {
        return writeOffAmount;
    }

    public void setWriteOffAmount(BigDecimal writeOffAmount) {
        this.writeOffAmount = writeOffAmount;
    }
    public BigDecimal getManagementFees() {
        return managementFees;
    }

    public void setManagementFees(BigDecimal managementFees) {
        this.managementFees = managementFees;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getReceivingDate() {
        return receivingDate;
    }

    public void setReceivingDate(Date receivingDate) {
        this.receivingDate = receivingDate;
    }

    public String getReceivingType() {
        return receivingType;
    }

    public void setReceivingType(String receivingType) {
        this.receivingType = receivingType;
    }

    public String getReceivingMethod() {
        return receivingMethod;
    }

    public void setReceivingMethod(String receivingMethod) {
        this.receivingMethod = receivingMethod;
    }
}
