package com.ejianc.business.laborservice.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.search.DocValueFormat;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.laborservice.mapper.LaborserviceInvoiceApplyMapper;
import com.ejianc.business.laborservice.bean.LaborserviceInvoiceApplyEntity;
import com.ejianc.business.laborservice.service.ILaborserviceInvoiceApplyService;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 劳务公司发票申请
 * 
 * @author generator
 * 
 */
@Service("laborserviceInvoiceApplyService")
public class LaborserviceInvioceApplyServiceImpl extends BaseServiceImpl<LaborserviceInvoiceApplyMapper, LaborserviceInvoiceApplyEntity> implements ILaborserviceInvoiceApplyService {
    public BigDecimal getIncomedAmount(Long incomeContractId){
        LambdaQueryWrapper<LaborserviceInvoiceApplyEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LaborserviceInvoiceApplyEntity::getIncomeContractId,incomeContractId);
        List<LaborserviceInvoiceApplyEntity> entities = baseMapper.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(entities)) {
            BigDecimal bigDecimal = new BigDecimal(0);
            List<BigDecimal> collect = entities.stream().map(LaborserviceInvoiceApplyEntity::getApplyInvoiceAmount).collect(Collectors.toList());
            for (int i = 0; i < collect.size(); i++) {
                if (collect.get(i)!=null) {
                    bigDecimal = bigDecimal.add(collect.get(i));
                }
            }
            return bigDecimal;
        }else {
            return null;
        }
    }
}
