package com.ejianc.business.laborservice.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeReceivingEntity;
import com.ejianc.business.laborservice.bean.LaborserviceInvoiceApplyEntity;
import com.ejianc.business.laborservice.mapper.LaborserviceIncomeContractMapper;
import com.ejianc.business.laborservice.mapper.LaborserviceIncomeReceivingMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;

@Service("laborserviceIncomeReceiving") 
public class LaborserviceIncomeReceivingBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private LaborserviceIncomeReceivingMapper receivingMapper;

	@Autowired
	private LaborserviceIncomeContractMapper incomeContractMapper;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		LambdaQueryWrapper<LaborserviceIncomeReceivingEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(LaborserviceIncomeReceivingEntity::getId, billId);
		LaborserviceIncomeReceivingEntity receivingEntity = receivingMapper.selectOne(wrapper);
		BigDecimal receivingAmount = receivingEntity.getReceivingAmount(); //本次收款金额
		LaborserviceIncomeContractEntity incomeContractEntity = incomeContractMapper.selectById(receivingEntity.getIncomeContractId());
		logger.info("id:"+incomeContractEntity.getId()+":原累计收款数："+incomeContractEntity.getAccumulateReceivingAmount()+",本次收款数："+receivingAmount);
		if (ObjectUtil.isNotEmpty(receivingAmount)) {
			BigDecimal accumulateReceivingAmount = incomeContractEntity.getAccumulateReceivingAmount();
			if (ObjectUtil.isEmpty(accumulateReceivingAmount)) {
				accumulateReceivingAmount = new BigDecimal(0);
			}
			BigDecimal newAmount = accumulateReceivingAmount.add(receivingAmount);
			incomeContractEntity.setAccumulateReceivingAmount(newAmount);
			incomeContractMapper.updateById(incomeContractEntity);
			logger.info("更新累计收款数值："+incomeContractEntity.getAccumulateReceivingAmount());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
