package com.ejianc.business.laborservice.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 劳务公司支出合同
 * 
 * @author generator
 * 
 */
 @TableName("zzyj_laborservice_expend_contract")
public class LaborserviceExpendContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="contract_status")
    private String contractStatus; // 合同状态
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value = "income_contract_id")
    private Long incomeContractId;//收入合同id
    @TableField(value="income_contract_code")
    private String incomeContractCode; // 收入合同编号
    @TableField(value = "income_contract_name")
    private String incomeContractName;//收入合同名称
    @TableField(value="first_party_id")
    private Long firstPartyId; // 甲方id
    @TableField(value="first_party_name")
    private String firstPartyName; // 甲方
    @TableField(value="supplier_id")
    private String supplierId; // 乙方id
    @TableField(value="supplier")
    private String supplier; // 乙方
    @TableField(value="supplier_signer_cert_id")
    private String supplierSignerCertId; // 乙方签订人身份证编号
    /*@TableField(value = "supplier_signer_id")
    private Long supplierSignerId; //乙方签订人id
    @TableField(value = "supplier_signer")
    private String supplierSigner; //乙方签订人姓名*/
    @TableField(value="supplier_phone")
    private String supplierPhone; // 乙方签订人电话
    @TableField(value="project_manager_dept_id")
    private Long projectManagerDeptId; // 项目管理部id
    @TableField(value="project_manager_dept")
    private String projectManagerDept; // 项目管理部
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_address")
    private String projectAddress; // 项目地址
    @TableField(value="invoice_type_name")
    private String invoiceTypeName; // 发票类型
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率%
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同暂订含税金额
    @TableField(value="contract_accumulate_tax")
    private BigDecimal contractAccumulateTax; // 合同累计含税金额
    @TableField(value="management_rate")
    private BigDecimal managementRate; // 管理费率%
    @TableField(value="sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    @TableField(value="early_accmulate_expend_amount")
    private BigDecimal earlyAccmulateExpendAmount; // 期初累计付款金额
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="invoice_info")
    private String invoiceInfo; //发票备注信息
    @TableField(value="area_id")
    private String areaId; // 地区
    @TableField(value="area_name")
    private String areaName; // 地区名称

    @TableField(exist=false)
    @SubEntity(serviceName="laborserviceExpendContractZiService",pidName = "pid")
    private List<LaborserviceExpendContractZiEntity> laborserviceExpendContractZiList = new ArrayList<>(); // 劳务公司支出合同子表

    @TableField(value="sum_invoice_amount")
    private BigDecimal sumInvoiceAmount; // 累计开票金额


    public BigDecimal getSumInvoiceAmount() {
        return sumInvoiceAmount;
    }

    public void setSumInvoiceAmount(BigDecimal sumInvoiceAmount) {
        this.sumInvoiceAmount = sumInvoiceAmount;
    }

    public List<LaborserviceExpendContractZiEntity> getLaborserviceExpendContractZiList() {
        return laborserviceExpendContractZiList;
    }

    public void setLaborserviceExpendContractZiList(List<LaborserviceExpendContractZiEntity> laborserviceExpendContractZiList) {
        this.laborserviceExpendContractZiList = laborserviceExpendContractZiList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getIncomeContractId() {
        return incomeContractId;
    }

    public void setIncomeContractId(Long incomeContractId) {
        this.incomeContractId = incomeContractId;
    }

    public String getIncomeContractName() {
        return incomeContractName;
    }

    public void setIncomeContractName(String incomeContractName) {
        this.incomeContractName = incomeContractName;
    }

    public String getIncomeContractCode() {
        return incomeContractCode;
    }

    public void setIncomeContractCode(String incomeContractCode) {
        this.incomeContractCode = incomeContractCode;
    }
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    public String getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    /*public Long getSupplierSignerId() {
        return supplierSignerId;
    }

    public void setSupplierSignerId(Long supplierSignerId) {
        this.supplierSignerId = supplierSignerId;
    }

    public String getSupplierSigner() {
        return supplierSigner;
    }

    public void setSupplierSigner(String supplierSigner) {
        this.supplierSigner = supplierSigner;
    }*/

    public String getSupplierSignerCertId() {
        return supplierSignerCertId;
    }

    public void setSupplierSignerCertId(String supplierSignerCertId) {
        this.supplierSignerCertId = supplierSignerCertId;
    }
    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    public Long getProjectManagerDeptId() {
        return projectManagerDeptId;
    }

    public void setProjectManagerDeptId(Long projectManagerDeptId) {
        this.projectManagerDeptId = projectManagerDeptId;
    }
    public String getProjectManagerDept() {
        return projectManagerDept;
    }

    public void setProjectManagerDept(String projectManagerDept) {
        this.projectManagerDept = projectManagerDept;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractAccumulateTax() {
        return contractAccumulateTax;
    }

    public void setContractAccumulateTax(BigDecimal contractAccumulateTax) {
        this.contractAccumulateTax = contractAccumulateTax;
    }
    public BigDecimal getManagementRate() {
        return managementRate;
    }

    public void setManagementRate(BigDecimal managementRate) {
        this.managementRate = managementRate;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getEarlyAccmulateExpendAmount() {
        return earlyAccmulateExpendAmount;
    }

    public void setEarlyAccmulateExpendAmount(BigDecimal earlyAccmulateExpendAmount) {
        this.earlyAccmulateExpendAmount = earlyAccmulateExpendAmount;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getInvoiceInfo() {
        return invoiceInfo;
    }

    public void setInvoiceInfo(String invoiceInfo) {
        this.invoiceInfo = invoiceInfo;
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
}
