package com.ejianc.business.laborservice.controller;

import java.io.Serializable;

import com.ejianc.business.laborservice.service.ILaborserviceInvoiceApplyService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import com.ejianc.business.laborservice.service.ILaborserviceIncomeContractService;
import com.ejianc.business.laborservice.vo.LaborserviceIncomeContractVO;

/**
 * 劳务公司收入合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("laborserviceIncomeContract")
public class LaborserviceIncomeContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    //todo 编码规则待确认
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ILaborserviceIncomeContractService service;

    @Autowired
    private ILaborserviceInvoiceApplyService applyService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LaborserviceIncomeContractVO> saveOrUpdate(@RequestBody LaborserviceIncomeContractVO saveOrUpdateVO) {
    	LaborserviceIncomeContractEntity entity = BeanMapper.map(saveOrUpdateVO, LaborserviceIncomeContractEntity.class);
        UserContext userContextCache=sessionManager.getUserContext();
        if(entity.getId()==null||entity.getId()==0){
            //设置创建人姓名  
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam=BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String>billCode=billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()){
                //entity.setCode(billCode.getData());//此处需要根据实际修改删除本行或者下一行  
                entity.setBillCode(billCode.getData());//此处需要根据实际修改删除本行或者上一行  
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }else{
            //设置修改人姓名  
            entity.setUpdateUserName(userContextCache.getUserName());
        }
    	service.saveOrUpdate(entity, false);
    	LaborserviceIncomeContractVO vo = BeanMapper.map(entity, LaborserviceIncomeContractVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LaborserviceIncomeContractVO> queryDetail(Long id) {
    	LaborserviceIncomeContractEntity entity = service.selectById(id);
    	LaborserviceIncomeContractVO vo = BeanMapper.map(entity, LaborserviceIncomeContractVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborserviceIncomeContractVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LaborserviceIncomeContractVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(LaborserviceIncomeContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LaborserviceIncomeContractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            /*if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
            }*/
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<LaborserviceIncomeContractEntity> page = service.queryPage(param,false);
        IPage<LaborserviceIncomeContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborserviceIncomeContractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LaborserviceIncomeContractEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborserviceIncomeContract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refLaborIncomeContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LaborserviceIncomeContractVO>> refLaborserviceIncomeContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LaborserviceIncomeContractEntity> page = service.queryPage(param,false);
        IPage<LaborserviceIncomeContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborserviceIncomeContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    //根据队伍id和项目id查询关联合同
    @PostMapping("getUnionContractInfo")
    @ResponseBody
    public CommonResponse<IPage<LaborserviceIncomeContractVO>> getUnionContractInfo(@RequestBody QueryParam param){
        long projectId = Long.parseLong(param.getParams().get("projectId").getValue().toString());
        String teamId = param.getParams().get("supplierSignerId").getValue().toString();
        List<LaborserviceIncomeContractVO> unionContractInfo = service.getUnionContractInfo(teamId, projectId);
        if (CollectionUtils.isNotEmpty(unionContractInfo)) {
            IPage<LaborserviceIncomeContractVO> resp = new Page<>();
            resp.setRecords(unionContractInfo);
            resp.setTotal(unionContractInfo.size());
            resp.setSize(param.getPageSize());
            resp.setCurrent(param.getPageIndex());
            return CommonResponse.success(resp);
        } else {
            return CommonResponse.error("查询失败！");
        }
    }
    @GetMapping("queryExpendDetail")
    @ResponseBody
    public CommonResponse<LaborserviceIncomeContractVO> queryExpendDetail(Long id){
        LaborserviceIncomeContractVO contractVO = service.queryExpendDetail(id);
        return CommonResponse.success(contractVO);
    }


    /**
     * 参照树----收入支出合同数表
     *
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refIncomeContractTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> lazyFazdTree(@RequestParam(required=false) String condition,
                                                  //@RequestParam(required=false) Long pid,
                                                  @RequestParam(required = false) String searchText) {
        List<LaborserviceIncomeContractVO> dataList = null;
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
            }
            dataList = service.queryListTree(params);
            List<Map> maps = BeanMapper.mapList(dataList, Map.class);
            for (Map map : maps) {
                String name =  map.get("contractName").toString();
                map.remove("contractName");
                map.put("name",name);
            }
            return ResultAsTree.createTreeData(maps);
        } catch (Exception e) {
            return null;
        }
    }

    @PostMapping("listContractLedger")
    @ResponseBody
    public CommonResponse<IPage<LaborserviceIncomeContractVO>> listContractLedger(@RequestBody QueryParam param){
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplier");
        fuzzyFields.add("projectManagerDept");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            /*if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
            }*/
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        IPage<LaborserviceIncomeContractVO> pageData = service.listContractLedger(param);
        return CommonResponse.success(pageData);
    }
}
