package com.ejianc.business.laborservice.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.laborservice.vo.LaborserviceExpendContractVO;
import com.ejianc.business.laborservice.vo.LaborserviceIncomeContractVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * 劳务公司收入合同
 * 
 * @author generator
 * 
 */
@Mapper
public interface LaborserviceIncomeContractMapper extends BaseCrudMapper<LaborserviceIncomeContractEntity> {

    @Select({
            "select *  from zzyj_laborservice_income_contract where supplier_signer_id=#{teamId} and project_id = #{projectId}"
    })
    List<LaborserviceIncomeContractVO> getUnionContractInfo(@RequestParam String teamId,@RequestParam Long projectId);

    @Select({
            "select * from zzyj_laborservice_expend_contract where income_contract_id=#{id}"
    })
    List<LaborserviceExpendContractVO> queryExpendList(@RequestParam Long id);

    @Select({
            "SELECT * FROM (" +
                    "SELECT\n" +
                    "\ti.*,\n" +
                    "\tc.applyAmount applyAmount,\n" +
                    "\tc.applyCount applyCount,\n" +
                    "\td.receivingAmount receivingAmount,\n" +
                    "\td.receivingCount receivingCount,\n" +
                    "\te.lastInvoicing,\n" +
                    "\te.lastInvoicingDate,\n" +
                    "\tf.curYearInvoicing,\n" +
                    "\t( i.contract_accumulate_tax_mny - c.applyAmount ) remainingInvoicing ,\n" +
                    "\tproject.project_type_name\n" +
                    "FROM\n" +
                    "\tzzyj_laborservice_income_contract i\n" +
                    "\tLEFT JOIN ( SELECT income_contract_id, sum( apply_invoice_amount ) applyAmount, count(*) applyCount FROM zzyj_laborservice_invoice_apply GROUP BY income_contract_id ) c ON i.id = c.income_contract_id\n" +
                    "\tLEFT JOIN ( SELECT income_contract_id, sum( receiving_amount ) receivingAmount, count(*) receivingCount FROM zzyj_laborservice_income_receiving GROUP BY income_contract_id ) d ON i.id = d.income_contract_id\n" +
                    "\tLEFT JOIN ( SELECT income_contract_id, apply_invoice_amount lastInvoicing, cur_apply_date lastInvoicingDate FROM zzyj_laborservice_invoice_apply WHERE id IN ( SELECT max( id ) id FROM zzyj_laborservice_invoice_apply GROUP BY income_contract_id ) ) e ON i.id = e.income_contract_id\n" +
                    "\tLEFT JOIN ( SELECT income_contract_id, sum( apply_invoice_amount ) curYearInvoicing, cur_apply_date FROM zzyj_laborservice_invoice_apply WHERE YEAR ( cur_apply_date ) = YEAR ( CURDATE()) GROUP BY income_contract_id ) f ON i.id = f.income_contract_id\n" +
                    "\tLEFT JOIN zzyj_laborservice_project project on project.id = i.project_id"+
                    ") n ${ew.customSqlSegment}"
    })
    List<LaborserviceIncomeContractVO> listContractLedger(@Param(Constants.WRAPPER) QueryWrapper<Object> changeToQueryWrapper, @Param("page") IPage<LaborserviceIncomeContractVO> page);

    @Update("update `zzyj_laborservice_income_contract` set is_sign_expend_contract = #{isSign} where id = #{enrollId} and dr = 0 ")
    Boolean updateSignState(@Param("enrollId") Long enrollId, @Param("isSign") Integer isSign);

}
