package com.ejianc.business.laborservice.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.laborservice.bean.LaborserviceInvoiceInfoEntity;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.math.BigDecimal;

/**
 * 劳务公司发票信息
 * 
 * @author generator
 * 
 */
@Mapper
public interface LaborserviceInvoiceInfoMapper extends BaseCrudMapper<LaborserviceInvoiceInfoEntity> {
    @Select("SELECT IFNULL(sum(invoice_amount),0) sum_invoice_amount FROM `zzyj_laborservice_invoice_info`\n" +
            "where source_contract_id = #{contractId}\n" +
            "and dr = 0")
    BigDecimal querySumMnyByContractId(Long contractId);

    @Update("update `zzyj_laborservice_invoice_info` set income_contract_tax_mny = #{mny}" +
            "where source_contract_id =  #{incomeContractId} and dr = 0 ")
    void updateInconeContractMny(Long incomeContractId,BigDecimal mny);
}
