package com.ejianc.business.laborservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.laborservice.bean.LaborserviceExpendContractEntity;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractChangeEntity;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractHistoryEntity;
import com.ejianc.business.laborservice.controller.LaborserviceIncomeContractChangeController;
import com.ejianc.business.laborservice.mapper.LaborserviceIncomeContractChangeMapper;
import com.ejianc.business.laborservice.mapper.LaborserviceIncomeContractHistoryMapper;
import com.ejianc.business.laborservice.mapper.LaborserviceIncomeContractMapper;
import com.ejianc.business.laborservice.mapper.LaborserviceInvoiceInfoMapper;
import com.ejianc.business.laborservice.service.ILaborserviceExpendContractService;
import com.ejianc.business.laborservice.service.ILaborserviceInvoiceInfoService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("laborserviceIncomeContractChange") 
public class LaborserviceIncomeContractChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private LaborserviceIncomeContractChangeMapper changeMapper;
	@Autowired
	private LaborserviceIncomeContractMapper contractMapper;
	@Autowired
	private LaborserviceIncomeContractHistoryServiceImpl historyService;
	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private ILaborserviceExpendContractService expendContractService;

	@Autowired
	private LaborserviceInvoiceInfoMapper invoiceInfoMapper;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("-----------------合同变更开始---------------------");
		//查询修改记录
		LaborserviceIncomeContractChangeEntity changeEntity = changeMapper.selectById(billId);
		if (changeEntity!=null) {
			//查询原始合同
			LaborserviceIncomeContractEntity beforeChangeContractEntity = contractMapper.selectById(changeEntity.getBeforeChangeId());
			if (beforeChangeContractEntity!=null) {
				//转换为历史记录实体
				LaborserviceIncomeContractHistoryEntity historyEntity  = BeanMapper.map(beforeChangeContractEntity, LaborserviceIncomeContractHistoryEntity.class);
				historyEntity.setOldReviewId(beforeChangeContractEntity.getId());
				historyEntity.setId(null);
				historyService.saveOrUpdate(historyEntity);
				//变更合同转换为收入合同实体
				LaborserviceIncomeContractEntity contractEntity = BeanMapper.map(changeEntity, LaborserviceIncomeContractEntity.class);
				LaborserviceIncomeContractEntity laborserviceIncomeContractEntity = contractMapper.selectById(changeEntity.getBeforeChangeId());
				contractEntity.setId(changeEntity.getBeforeChangeId());
				contractEntity.setBillCode(laborserviceIncomeContractEntity.getBillCode());
				contractEntity.setBillState(laborserviceIncomeContractEntity.getBillState());
				contractEntity.setOrgId(laborserviceIncomeContractEntity.getOrgId());
				contractEntity.setOrgName(laborserviceIncomeContractEntity.getOrgName());
				contractEntity.setCreateUserName(laborserviceIncomeContractEntity.getCreateUserName());
				contractEntity.setCreateTime(laborserviceIncomeContractEntity.getCreateTime());
				contractEntity.setCreateUserCode(laborserviceIncomeContractEntity.getCreateUserCode());

				//更新合同内容
				logger.info("-------------------更新合同内容----------------:{}",JSONObject.toJSONString(contractEntity));
				int i = contractMapper.updateById(contractEntity);
				logger.info("-------------------合同已更新---------------------");
				//3.同步附件
				logger.info("原合同同步附件");
				//3.1将原合同附件同步到记录表中
				CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
						String.valueOf(contractEntity.getId()), "ZZYJ202311080007", "incomeContractFile",
						String.valueOf(historyEntity.getId()), "ZZYJ202311230020", "historyContractFile");
				logger.info("原合同合同同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());
				//3.2将变更合同附件同步到原合同汇总
				logger.info("变更合同同步附件");
				CommonResponse<String> changeResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(
						String.valueOf(changeEntity.getId()), "ZZYJ202311230019", "changeContractFile",
						String.valueOf(contractEntity.getId()), "ZZYJ202311080007", "incomeContractFile");
				logger.info("变更合同同步附件::::::::::::结果::" + JSONObject.toJSONString(changeResponse).toString());

				//将合同金额更新到支出合同以及发票登记中
				QueryParam param = new QueryParam();
				/** 租户隔离 */
				param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
				param.getParams().put("income_contract_id", new Parameter(QueryParam.EQ, contractEntity.getId()));
				List<LaborserviceExpendContractEntity> laborserviceExpendContractEntities = expendContractService.queryList(param);
				//logger.info("-------------------需要更新的支出合同个数:{}",laborserviceExpendContractEntities.size());
				if (CollectionUtil.isNotEmpty(laborserviceExpendContractEntities)){
					for (LaborserviceExpendContractEntity laborserviceExpendContractEntity : laborserviceExpendContractEntities) {
						laborserviceExpendContractEntity.setContractAccumulateTax(contractEntity.getContractAccumulateTaxMny());
						expendContractService.saveOrUpdate(laborserviceExpendContractEntity);
						logger.info("-------------------更新的支出合同:{}",laborserviceExpendContractEntity.getId());
						invoiceInfoMapper.updateInconeContractMny(laborserviceExpendContractEntity.getId(),contractEntity.getContractAccumulateTaxMny());
						logger.info("-------------------更新的发票登记:{}",laborserviceExpendContractEntity.getId());
					}
				}

				logger.info("合同变更结束------------------------");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更合同不允许撤回！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
