package com.ejianc.business.itax.mapper;

import com.ejianc.business.itax.bean.SalaryCollectDetailEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.itax.bean.SalaryCollectEntity;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 工人工资汇总
 * 
 * @author generator
 * 
 */
@Mapper
public interface SalaryCollectMapper extends BaseCrudMapper<SalaryCollectEntity> {

    @Select("SELECT GROUP_CONCAT(pid Separator ',') salaryids,id_num,name,phone,sum(money) as money,month_num,is_regist,last_month_state,count(*) as this_month_num,this_year_income,sum(money) as this_month_dlffje,expense_reduction,this_year_itax,special_deduction,last_month_wsb_itax,last_month_wsb_income \n" +
            "from (\n" +
            "SELECT * FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "where\tdr = 0 and salary_pay_state = '已发放'\n" +
            "and pid in (\n" +
            "SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "where dr = 0 and bill_state in (1,3) and DATE_FORMAT(bill_time, '%Y%m') = DATE_FORMAT(#{billTime}, '%Y%m'))\n" +
            "order by this_month_num desc\n" +
            ") a GROUP BY id_num")
    List<SalaryCollectDetailEntity> calculateCollectItax(Date billTime);
}

